<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Sistema Inventario'); ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <style>
        /* General Styles */
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(to right,rgb(5, 3, 83),rgb(3, 56, 100));
            color: #fff;
            margin: 0;
        }

        .navbar {
            background: linear-gradient(to right,rgb(5, 3, 83),rgb(3, 56, 100));

            border-bottom: 2px solidrgb(0, 71, 224);
        }

        .navbar-brand {
            font-weight: 700;
            font-size: 3rem;
            background: linear-gradient(to right, rgb(255, 255, 255), rgb(255, 255, 255));
-webkit-background-clip: text;
-webkit-text-fill-color: transparent;
        }

        .navbar-nav .nav-link {
            color: #b0b0b0;
            font-weight: 500;
        }

        .navbar-nav .nav-link:hover {
            color: #ffffff;
            text-decoration: underline;
        }

        .container {
            max-width: 1200px;
            margin-top: 50px;
            z-index: 10;
        }

        .card-custom {
            border-radius: 10px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
            background-color: #fff;
            color: #333;
            transition: transform 0.3s ease-in-out;
        }

        .card-custom:hover {
            transform: scale(1.05);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15);
        }

        .card-header {
            background: linear-gradient(to right, #2575fc, #6a11cb);
            color: #fff;
            font-weight: 600;
        }

        .footer {
            background: linear-gradient(to right,rgb(5, 3, 83),rgb(3, 56, 100));
            color: #fff;
            padding: 20px;
            text-align: center;
            font-size: 0.9rem;
        }

        /* Responsive Navbar for small screens */
        @media (max-width: 768px) {
            .navbar-brand {
                font-size: 1.2rem;
            }

            .navbar-nav .nav-link {
                font-size: 0.9rem;
            }
        }

        /* Custom button styles */
        .btn-custom {
            background-color: #2575fc;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 50px;
            font-weight: 600;
            transition: background-color 0.3s ease;
        }

        .btn-custom:hover {
            background-color: #6a11cb;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
<nav class="navbar navbar-expand-md navbar-dark bg-dark shadow-sm">
    <div class="container">
        <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
            Sistema de Inventario
        </a>

        <!-- Botón para responsive -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
            aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php echo e(__('Toggle navigation')); ?>">
            <span class="navbar-toggler-icon"></span>
        </button>

        <!-- Contenido del navbar -->
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <!-- Menú izquierdo -->
            <ul class="navbar-nav me-auto">
                <!-- Dropdown de Menú -->
            </ul>

            <!-- Menú derecho: usuario y logout -->
            <ul class="navbar-nav ms-auto">
                <li class="nav-item dropdown">
                    <a id="navbarDropdownMenu" class="nav-link dropdown-toggle" href="#" role="button"
                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        Menú
                    </a>
                    <div class="dropdown-menu dropdown-menu-dark" aria-labelledby="navbarDropdownMenu">
                        <a class="dropdown-item" href="<?php echo e(route('tipos-producto.index')); ?>">Tipos de Producto</a>
                        <a class="dropdown-item" href="<?php echo e(route('proviene-producto.index')); ?>">Proviene Producto</a>
                        <a class="dropdown-item" href="<?php echo e(route('sucursales.index')); ?>">Sucursales</a>
                        <a class="dropdown-item" href="<?php echo e(route('departamentos.index')); ?>">Departamentos</a>
                        <a class="dropdown-item" href="<?php echo e(route('productos.index')); ?>">Productos</a>
                    </div>
                </li>
                <?php if(auth()->guard()->guest()): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                    </li>
                    <?php if(Route::has('register')): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a>
                        </li>
                    <?php endif; ?>
                <?php else: ?>
                    <li class="nav-item dropdown">
                        <a id="navbarDropdownUser" class="nav-link dropdown-toggle" href="#" role="button"
                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <?php echo e(Auth::user()->name); ?>

                        </a>

                        <div class="dropdown-menu dropdown-menu-end dropdown-menu-dark" aria-labelledby="navbarDropdownUser">
                            <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                onclick="event.preventDefault();
                                    document.getElementById('logout-form').submit();">
                                <?php echo e(__('Cerrar sesión')); ?>

                            </a>

                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"
                                style="display: none;">
                                <?php echo csrf_field(); ?>
                            </form>
                        </div>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>





    <!-- Main Content -->
    <div class="container mt-5">
        <?php echo $__env->yieldContent('content'); ?>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>&copy; Desarrollado con ❤️ por el departamento de  <strong>TI </strong>.</p>


    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH /home/programador/Documents/inventario/resources/views/layouts/app.blade.php ENDPATH**/ ?>