<!-- resources/views/productos/index.blade.php -->


<?php $__env->startSection('content'); ?>
    <div class="container">
        <h1>Productos</h1>

        <a href="<?php echo e(route('productos.create')); ?>" class="btn btn-primary mb-3">Crear Producto</a>

        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <table class="table">
            <thead>
                <tr>
                    <th>Cod. Producto</th>
                    <th>Cod. Tipo  Producto</th>

                    <th>Descripción</th>
                    <th>Cantidad</th>
                    <th>Fecha de Caducidad</th>
                    <th>Mantenimiento</th>
                    <th>Tipo Producto</th>
                    <th>Departamento</th>
                    <th>Proviene Producto</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($producto->id_producto); ?></td>
                        <td><?php echo e($producto->tipoProducto->id_tipo); ?></td>

                        <td><?php echo e($producto->descripcion); ?></td>
                        <td><?php echo e($producto->cantidad); ?></td>
                        <td><?php echo e($producto->fecha_caducidad); ?></td>
                        <td><?php echo e($producto->mantenimiento); ?></td>
                        <td><?php echo e($producto->tipoProducto->descripcion); ?></td>
                        <td><?php echo e($producto->departamento->descripcion); ?></td>
                        <td><?php echo e($producto->provieneProducto->descripcion); ?></td>
                        <td><?php echo e($producto->estado ? 'Activo' : 'Inactivo'); ?></td>
                        <td>
                            <a href="<?php echo e(route('productos.edit', $producto->id_producto)); ?>" class="btn btn-warning btn-sm">Editar</a>
                            <form action="<?php echo e(route('productos.destroy', $producto->id_producto)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-sm">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <?php echo e($productos->links()); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/hacking/Escritorio/inventario/resources/views/productos/index.blade.php ENDPATH**/ ?>