<?php $__env->startSection('content'); ?>
    <div class="container">
        <h1>Lista de Proviene Productos</h1>
        <a href="<?php echo e(route('proviene-producto.create')); ?>" class="btn btn-primary">Crear Proviene Producto</a>

        <table class="table mt-4">
            <thead>
                <tr>
                    <th>Dirección</th>
                    <th>Descripción</th>
                    <th>Estado</th>
                    <th>Origen</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $provieneProductos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provieneProducto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($provieneProducto->direccion); ?></td>
                        <td><?php echo e($provieneProducto->descripcion); ?></td>
                        <td><?php echo e($provieneProducto->estado ? 'Activo' : 'Inactivo'); ?></td>
                        <td><?php echo e($provieneProducto->origen); ?></td>
                        <td>
                            <a href="<?php echo e(route('proviene-producto.edit', $provieneProducto->id_proviene_producto)); ?>" class="btn btn-warning">Editar</a>
                            <form action="<?php echo e(route('proviene-producto.destroy', $provieneProducto->id_proviene_producto)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <!-- Paginación -->
        <?php echo e($provieneProductos->links()); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/hacking/Escritorio/inventario/resources/views/proviene-producto/index.blade.php ENDPATH**/ ?>