<?php $__env->startSection('title', 'Sucursales'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mt-4">Lista de Sucursales</h2>
    <a href="<?php echo e(route('sucursales.create')); ?>" class="btn btn-primary mb-3">Nueva Sucursal</a>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Descripción</th>
                <th>Ubicación</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($sucursal->id_sucursal); ?></td>
                    <td><?php echo e($sucursal->descripcion); ?></td>
                    <td><?php echo e($sucursal->ubicacion); ?></td>
                    <td><?php echo e($sucursal->estado ? 'Activo' : 'Inactivo'); ?></td>
                    <td>
                    <a href="<?php echo e(route('sucursales.edit', ['sucursal' => $sucursal->id_sucursal])); ?>" class="btn btn-warning">Editar</a>
                    <form action="<?php echo e(route('sucursales.destroy', ['sucursal' => $sucursal->id_sucursal])); ?>" method="POST" style="display:inline;">
                    <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger" onclick="return confirm('¿Seguro que deseas eliminar?')">Eliminar</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/hacking/Escritorio/inventario/resources/views/sucursales/index.blade.php ENDPATH**/ ?>