<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mb-4">Lista de Departamentos</h2>
    <a href="<?php echo e(route('departamentos.create')); ?>" class="btn btn-primary mb-3">Nuevo Departamento</a>
    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Descripción</th>
                <th>Estado</th>
                <th>Sucursal </th>
                <th>Sucursal Ubicacion </th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $departamentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $departamento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($departamento->id_departamento); ?></td>
                <td><?php echo e($departamento->descripcion); ?></td>
                <td><?php echo e($departamento->estado ? 'Activo' : 'Inactivo'); ?></td>
                <td><?php echo e($departamento->sucursal->descripcion ?? 'Sin Sucursal'); ?></td>

                <td><?php echo e($departamento->sucursal->ubicacion ?? 'Sin ubicacion'); ?></td>
                <td>
                    <a href="<?php echo e(route('departamentos.edit', $departamento->id_departamento)); ?>" class="btn btn-warning btn-sm">Editar</a>
                    <form action="<?php echo e(route('departamentos.destroy', $departamento->id_departamento)); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger btn-sm">Eliminar</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php echo e($departamentos->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/programador/Documents/inventario/resources/views/departamentos/index.blade.php ENDPATH**/ ?>