<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <!-- Menú Lateral -->

            <!-- Contenido Principal -->
            <div class="col-md-12 p-4">
                <h1 class="mb-4" style="font-family: 'Poppins', sans-serif; font-weight: 700;">Productos</h1>
                <a href="<?php echo e(route('productos.create')); ?>" class="btn btn-custom mb-3">Crear Producto</a>

                <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                <?php endif; ?>

                <!-- Filtros de Búsqueda -->
                <form method="GET" action="<?php echo e(route('productos.welcome')); ?>" class="mb-4">
    <div class="row">
        <!-- Filtro por Descripción -->
        <div class="col-md-4">
            <label for="descripcion" style="font-weight: 600;">Descripción</label>
            <input type="text" name="descripcion" id="descripcion" class="form-control" value="<?php echo e(request('descripcion')); ?>">
        </div>

        <!-- Filtro por Tipo de Producto -->
        <div class="col-md-4">
            <label for="id_tipoproducto" style="font-weight: 600;">Tipo de Producto</label>
            <select name="id_tipoproducto" id="id_tipoproducto" class="form-control">
                <option value="">Todos</option>
                <?php $__currentLoopData = $tiposProductos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($tipo->id_tipo); ?>" <?php echo e(request('id_tipoproducto') == $tipo->id_tipo ? 'selected' : ''); ?>>
                        <?php echo e($tipo->tipo); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <!-- Filtro por Departamento -->
        <div class="col-md-4">
            <label for="departamento" style="font-weight: 600;">Departamento</label>
            <select name="departamento" id="departamento" class="form-control">
                <option value="">Todos</option>
                <?php $__currentLoopData = $departamentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $departamento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($departamento->id_departamento); ?>" <?php echo e(request('departamento') == $departamento->id_departamento ? 'selected' : ''); ?>>
                        <?php echo e($departamento->descripcion); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <!-- Filtro por Proviene Producto -->
        <div class="col-md-4">
            <label for="proviene_producto" style="font-weight: 600;">Proviene Producto</label>
            <select name="proviene_producto" id="proviene_producto" class="form-control">
                <option value="">Todos</option>
                <?php $__currentLoopData = $provieneProductos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proviene): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($proviene->id_proviene_producto); ?>" <?php echo e(request('proviene_producto') == $proviene->id_proviene_producto ? 'selected' : ''); ?>>
                        <?php echo e($proviene->descripcion); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <!-- Filtro por ID Producto -->
        <div class="col-md-4">
            <label for="id_producto" style="font-weight: 600;">Cod. Producto</label>
            <input type="text" name="id_producto" id="id_producto" class="form-control" value="<?php echo e(request('id_producto')); ?>">
        </div>

        <div class="col-md-4 d-flex align-items-end">
            <button type="submit" class="btn btn-custom">Buscar</button>
<br>
            <a href="<?php echo e(route('productos.welcome')); ?>" class="btn btn-secondary ml-2">Limpiar</a>
        </div>
    </div>
</form>


                <div class="row">
                    <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4 mb-4">
                            <div class="card card-custom">
                                <img class="card-img-top" src="<?php echo e($producto->imagen); ?>" alt="Imagen Producto" style="height: 200px; object-fit: cover;">
                                <div class="card-body">
                                    <h5 class="card-title"><?php echo e($producto->descripcion); ?></h5>
                                    <p class="card-text">
                                        <strong>Cod. Producto:</strong> <?php echo e($producto->id_producto); ?><br>
                                        <strong>Cod. Tipo Producto:</strong> <?php echo e($producto->tipoProducto->id_tipo); ?><br>
                                        <strong>Tipo Producto:</strong> <?php echo e($producto->tipoProducto->tipo); ?><br>
                                        <strong>Cantidad:</strong> <?php echo e($producto->cantidad); ?><br>
                                        <strong>Fecha de Caducidad:</strong> <?php echo e($producto->fecha_caducidad); ?><br>
                                        <strong>Mantenimiento:</strong> <?php echo e($producto->mantenimiento); ?><br>

                                        <strong>Departamento:</strong> <?php echo e($producto->departamento->descripcion); ?><br>
                                        <strong>Proviene Producto:</strong> <?php echo e($producto->provieneProducto->descripcion); ?><br>
                                        <strong>Estado:</strong> <?php echo e($producto->estado ? 'Activo' : 'Inactivo'); ?><br>
                                    </p>
                                    <a href="<?php echo e(route('productos.edit', $producto->id_producto)); ?>" class="btn btn-success">Editar</a>
                                    <form action="<?php echo e(route('productos.destroy', $producto->id_producto)); ?>" method="POST" style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger btn-sm">Eliminar</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Paginación -->
                <?php echo e($productos->links()); ?>

            </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const menu = document.getElementById("menu-lateral");
            const menuIcon = document.getElementById("menu-icon");
            const menuItems = document.getElementById("menu-items");
            const menuTitle = document.querySelector(".menu-title");

            menu.style.width = "60px";
            menu.style.overflow = "hidden";
            menuItems.style.display = "none";
            menuTitle.style.display = "none";

            menuIcon.addEventListener("click", function () {
                if (menu.style.width === "60px") {
                    menu.style.width = "250px";
                    menuItems.style.display = "block";
                    menuTitle.style.display = "block";
                } else {
                    menu.style.width = "60px";
                    menuItems.style.display = "none";
                    menuTitle.style.display = "none";
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<style>
    /* Estilos del menú lateral */
    #menu-lateral {
        background: transparent; /* Fondo transparente */        height: 100vh;
        transition: width 0.3s;
        padding-top: 20px;
    }

    #menu-lateral .nav-link {
        font-weight: 600;
        color: #fff;
    }

    #menu-lateral .nav-link:hover {
        color: #2575fc;
        text-decoration: underline;
    }

    /* Estilos del botón personalizado */
    .btn-custom {
        background-color: #2575fc;
        color: white;
        border-radius: 30px;
        padding: 10px 20px;
        font-weight: 600;
        transition: background-color 0.3s ease;
    }

    .btn-custom:hover {
        background-color: #6a11cb;
    }

    /* Estilos de las tarjetas de productos */
    .card-custom {
        border-radius: 10px;
        box-shadow: 0 10px 20px rgba(197, 15, 15, 0.1);
        transition: transform 0.3s ease-in-out;
    }

    .card-custom:hover {
        transform: scale(1.05);
        box-shadow: 0 15px 30px rgba(161, 0, 0, 0.15);
    }

</style>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/programador/Documents/inventario/resources/views/welcome.blade.php ENDPATH**/ ?>