<?php $__env->startSection('content'); ?>
    <div class="container">
        <h1>Tipos de Producto</h1>

        <a href="<?php echo e(route('tipos-producto.create')); ?>" class="btn btn-primary">Crear Tipo de Producto</a>

        <table class="table mt-3">
            <thead>
                <tr>
                    <th>Codigo</th>
                    <th>Tipo</th>
                    <th>Descripción</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($tipo->id_tipo); ?></td>
                        <td><?php echo e($tipo->tipo); ?></td>
                        <td><?php echo e($tipo->descripcion); ?></td>
                        <td><?php echo e($tipo->estado ? 'Activo' : 'Inactivo'); ?></td>
                        <td>
                            <a href="<?php echo e(route('tipos-producto.edit', $tipo->id_tipo)); ?>" class="btn btn-warning">Editar</a>
                            <form action="<?php echo e(route('tipos-producto.destroy', $tipo->id_tipo)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <?php echo e($tipos->links()); ?> <!-- Paginación -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/programador/Documents/inventario/resources/views/tipos-producto/index.blade.php ENDPATH**/ ?>