<?php $__env->startSection('title', 'Editar Departamento'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <h2>Editar Departamento</h2>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
<form action="<?php echo e(route('departamentos.update', ['departamento' => $departamento->id_departamento])); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>

    <div class="form-group">
        <label for="descripcion">Descripción</label>
        <input type="text" name="descripcion" id="descripcion" class="form-control" value="<?php echo e(old('descripcion', $departamento->descripcion)); ?>" required>
    </div>

    <div class="form-group">
        <label for="estado">Estado</label>
        <select name="estado" id="estado" class="form-control">
            <option value="1" <?php echo e($departamento->estado == 1 ? 'selected' : ''); ?>>Activo</option>
            <option value="0" <?php echo e($departamento->estado == 0 ? 'selected' : ''); ?>>Inactivo</option>
        </select>
    </div>

    <div class="form-group">
        <label for="id_sucursal">Sucursal</label>
        <select name="id_sucursal" id="id_sucursal" class="form-control">
            <?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($sucursal->id_sucursal); ?>" <?php echo e($departamento->id_sucursal == $sucursal->id_sucursal ? 'selected' : ''); ?>>
                    <?php echo e($sucursal->descripcion); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <button type="submit" class="btn btn-primary">Actualizar</button>
</form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/programador/Documents/inventario/resources/views/departamentos/edit.blade.php ENDPATH**/ ?>