<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProductoController;
use App\Http\Controllers\TipoProductoController;
use App\Http\Controllers\ProvieneProductoController;
use App\Http\Controllers\DepartamentoController;
use App\Http\Controllers\SucursalController;
use App\Http\Controllers\AuthController;


Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');
Route::post('/logout', [AuthController::class, 'destroy'])->name('logout');


// Agrupar rutas protegidas con middleware 'auth'
Route::middleware(['auth'])->group(function () {
    Route::get('/', [ProductoController::class, 'showWithImageFromWelcome'])->name('productos.welcome');

    Route::resource('sucursales', SucursalController::class)->parameters([
        'sucursales' => 'sucursal',
    ]);

    Route::resource('departamentos', DepartamentoController::class);

    Route::resource('tipos-producto', TipoProductoController::class)->parameters([
        'tipos-producto' => 'tipoProducto',
    ]);

    Route::resource('proviene-producto', ProvieneProductoController::class);

    Route::resource('productos', ProductoController::class);

    // Vista principal protegida
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    // Perfil
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__ . '/auth.php';
