@extends('layouts.app')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <!-- Menú Lateral -->

            <!-- Contenido Principal -->
            <div class="col-md-12 p-4">
                <h1 class="mb-4" style="font-family: 'Poppins', sans-serif; font-weight: 700;">Productos</h1>
                <a href="{{ route('productos.create') }}" class="btn btn-custom mb-3">Crear Producto</a>

                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif

                <!-- Filtros de Búsqueda -->
                <form method="GET" action="{{ route('productos.welcome') }}" class="mb-4">
    <div class="row">
        <!-- Filtro por Descripción -->
        <div class="col-md-4">
            <label for="descripcion" style="font-weight: 600;">Descripción</label>
            <input type="text" name="descripcion" id="descripcion" class="form-control" value="{{ request('descripcion') }}">
        </div>

        <!-- Filtro por Tipo de Producto -->
        <div class="col-md-4">
            <label for="id_tipoproducto" style="font-weight: 600;">Tipo de Producto</label>
            <select name="id_tipoproducto" id="id_tipoproducto" class="form-control">
                <option value="">Todos</option>
                @foreach($tiposProductos as $tipo)
                    <option value="{{ $tipo->id_tipo }}" {{ request('id_tipoproducto') == $tipo->id_tipo ? 'selected' : '' }}>
                        {{ $tipo->tipo }}
                    </option>
                @endforeach
            </select>
        </div>

        <!-- Filtro por Departamento -->
        <div class="col-md-4">
            <label for="departamento" style="font-weight: 600;">Departamento</label>
            <select name="departamento" id="departamento" class="form-control">
                <option value="">Todos</option>
                @foreach($departamentos as $departamento)
                    <option value="{{ $departamento->id_departamento }}" {{ request('departamento') == $departamento->id_departamento ? 'selected' : '' }}>
                        {{ $departamento->descripcion }}
                    </option>
                @endforeach
            </select>
        </div>

        <!-- Filtro por Proviene Producto -->
        <div class="col-md-4">
            <label for="proviene_producto" style="font-weight: 600;">Proviene Producto</label>
            <select name="proviene_producto" id="proviene_producto" class="form-control">
                <option value="">Todos</option>
                @foreach($provieneProductos as $proviene)
                    <option value="{{ $proviene->id_proviene_producto }}" {{ request('proviene_producto') == $proviene->id_proviene_producto ? 'selected' : '' }}>
                        {{ $proviene->descripcion }}
                    </option>
                @endforeach
            </select>
        </div>

        <!-- Filtro por ID Producto -->
        <div class="col-md-4">
            <label for="id_producto" style="font-weight: 600;">Cod. Producto</label>
            <input type="text" name="id_producto" id="id_producto" class="form-control" value="{{ request('id_producto') }}">
        </div>

        <div class="col-md-4 d-flex align-items-end">
            <button type="submit" class="btn btn-custom">Buscar</button>
<br>
            <a href="{{ route('productos.welcome') }}" class="btn btn-secondary ml-2">Limpiar</a>
        </div>
    </div>
</form>


                <div class="row">
                    @foreach($productos as $producto)
                        <div class="col-md-4 mb-4">
                            <div class="card card-custom">
                                <img class="card-img-top" src="{{ $producto->imagen }}" alt="Imagen Producto" style="height: 200px; object-fit: cover;">
                                <div class="card-body">
                                    <h5 class="card-title">{{ $producto->descripcion }}</h5>
                                    <p class="card-text">
                                        <strong>Cod. Producto:</strong> {{ $producto->id_producto }}<br>
                                        <strong>Cod. Tipo Producto:</strong> {{ $producto->tipoProducto->id_tipo }}<br>
                                        <strong>Tipo Producto:</strong> {{ $producto->tipoProducto->tipo }}<br>
                                        <strong>Cantidad:</strong> {{ $producto->cantidad }}<br>
                                        <strong>Fecha de Caducidad:</strong> {{ $producto->fecha_caducidad }}<br>
                                        <strong>Mantenimiento:</strong> {{ $producto->mantenimiento }}<br>

                                        <strong>Departamento:</strong> {{ $producto->departamento->descripcion }}<br>
                                        <strong>Proviene Producto:</strong> {{ $producto->provieneProducto->descripcion }}<br>
                                        <strong>Estado:</strong> {{ $producto->estado ? 'Activo' : 'Inactivo' }}<br>
                                    </p>
                                    <a href="{{ route('productos.edit', $producto->id_producto) }}" class="btn btn-success">Editar</a>
                                    <form action="{{ route('productos.destroy', $producto->id_producto) }}" method="POST" style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm">Eliminar</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Paginación -->
                {{ $productos->links() }}
            </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const menu = document.getElementById("menu-lateral");
            const menuIcon = document.getElementById("menu-icon");
            const menuItems = document.getElementById("menu-items");
            const menuTitle = document.querySelector(".menu-title");

            menu.style.width = "60px";
            menu.style.overflow = "hidden";
            menuItems.style.display = "none";
            menuTitle.style.display = "none";

            menuIcon.addEventListener("click", function () {
                if (menu.style.width === "60px") {
                    menu.style.width = "250px";
                    menuItems.style.display = "block";
                    menuTitle.style.display = "block";
                } else {
                    menu.style.width = "60px";
                    menuItems.style.display = "none";
                    menuTitle.style.display = "none";
                }
            });
        });
    </script>
@endsection

<style>
    /* Estilos del menú lateral */
    #menu-lateral {
        background: transparent; /* Fondo transparente */        height: 100vh;
        transition: width 0.3s;
        padding-top: 20px;
    }

    #menu-lateral .nav-link {
        font-weight: 600;
        color: #fff;
    }

    #menu-lateral .nav-link:hover {
        color: #2575fc;
        text-decoration: underline;
    }

    /* Estilos del botón personalizado */
    .btn-custom {
        background-color: #2575fc;
        color: white;
        border-radius: 30px;
        padding: 10px 20px;
        font-weight: 600;
        transition: background-color 0.3s ease;
    }

    .btn-custom:hover {
        background-color: #6a11cb;
    }

    /* Estilos de las tarjetas de productos */
    .card-custom {
        border-radius: 10px;
        box-shadow: 0 10px 20px rgba(197, 15, 15, 0.1);
        transition: transform 0.3s ease-in-out;
    }

    .card-custom:hover {
        transform: scale(1.05);
        box-shadow: 0 15px 30px rgba(161, 0, 0, 0.15);
    }

</style>
