@extends('layouts.app')

@section('content')
    <div class="container">
        <h1>Tipos de Producto</h1>

        <a href="{{ route('tipos-producto.create') }}" class="btn btn-primary">Crear Tipo de Producto</a>

        <table class="table mt-3">
            <thead>
                <tr>
                    <th>Codigo</th>
                    <th>Tipo</th>
                    <th>Descripción</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($tipos as $tipo)
                    <tr>
                        <td>{{ $tipo->id_tipo }}</td>
                        <td>{{ $tipo->tipo }}</td>
                        <td>{{ $tipo->descripcion }}</td>
                        <td>{{ $tipo->estado ? 'Activo' : 'Inactivo' }}</td>
                        <td>
                            <a href="{{ route('tipos-producto.edit', $tipo->id_tipo) }}" class="btn btn-warning">Editar</a>
                            <form action="{{ route('tipos-producto.destroy', $tipo->id_tipo) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        {{ $tipos->links() }} <!-- Paginación -->
    </div>
@endsection
