@extends('layouts.app')

@section('content')
    <div class="container">
        <h1>Editar Tipo de Producto</h1>

        <form action="{{ route('tipos-producto.update', $tipoProducto) }}" method="POST">
    @csrf
    @method('PUT')
    <div class="form-group">
        <label for="tipo">Tipo</label>
        <input type="text" name="tipo" id="tipo" class="form-control" value="{{ $tipoProducto->tipo }}" required>
    </div>
    <div class="form-group">
        <label for="descripcion">Descripción</label>
        <textarea name="descripcion" id="descripcion" class="form-control" required>{{ $tipoProducto->descripcion }}</textarea>
    </div>
    <div class="form-group">
        <label for="estado">Estado</label>
        <select name="estado" id="estado" class="form-control" required>
            <option value="1" {{ $tipoProducto->estado == 1 ? 'selected' : '' }}>Activo</option>
            <option value="0" {{ $tipoProducto->estado == 0 ? 'selected' : '' }}>Inactivo</option>
        </select>
    </div>
    <button type="submit" class="btn btn-success mt-3">Actualizar</button>
</form>

    </div>
@endsection
