@extends('layouts.app')

@section('title', 'Sucursales')

@section('content')
<div class="container">
    <h2 class="mt-4">Lista de Sucursales</h2>
    <a href="{{ route('sucursales.create') }}" class="btn btn-primary mb-3">Nueva Sucursal</a>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Descripción</th>
                <th>Ubicación</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach($sucursales as $sucursal)
                <tr>
                    <td>{{ $sucursal->id_sucursal }}</td>
                    <td>{{ $sucursal->descripcion }}</td>
                    <td>{{ $sucursal->ubicacion }}</td>
                    <td>{{ $sucursal->estado ? 'Activo' : 'Inactivo' }}</td>
                    <td>
                    <a href="{{ route('sucursales.edit', ['sucursal' => $sucursal->id_sucursal]) }}" class="btn btn-warning">Editar</a>
                    <form action="{{ route('sucursales.destroy', ['sucursal' => $sucursal->id_sucursal]) }}" method="POST" style="display:inline;">
                    @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger" onclick="return confirm('¿Seguro que deseas eliminar?')">Eliminar</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
