@extends('layouts.app')

@section('title', 'Editar Sucursal')

@section('content')
<div class="container">
    <h2>Editar Sucursal</h2>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('sucursales.update', $sucursal->id_sucursal) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label>Descripción:</label>
            <input type="text" name="descripcion" class="form-control" value="{{ $sucursal->descripcion }}" required>
        </div>
        <div class="mb-3">
            <label>Ubicación:</label>
            <input type="text" name="ubicacion" class="form-control" value="{{ $sucursal->ubicacion }}" required>
        </div>
        <div class="mb-3">
            <label>Estado:</label>
            <select name="estado" class="form-control">
                <option value="1" {{ $sucursal->estado ? 'selected' : '' }}>Activo</option>
                <option value="0" {{ !$sucursal->estado ? 'selected' : '' }}>Inactivo</option>
            </select>
        </div>

        <button type="submit" class="btn btn-success">Actualizar</button>
        <a href="{{ route('sucursales.index') }}" class="btn btn-secondary">Volver</a>
    </form>
</div>
@endsection
