@extends('layouts.app')

@section('title', 'Nueva Sucursal')

@section('content')
<div class="container">
    <h2>Crear Nueva Sucursal</h2>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('sucursales.store') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label>Descripción:</label>
            <input type="text" name="descripcion" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Ubicación:</label>
            <input type="text" name="ubicacion" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Estado:</label>
            <select name="estado" class="form-control">
                <option value="1">Activo</option>
                <option value="0">Inactivo</option>
            </select>
        </div>
        <button type="submit" class="btn btn-success">Guardar</button>
        <a href="{{ route('sucursales.index') }}" class="btn btn-secondary">Volver</a>
    </form>
</div>
@endsection
