@extends('layouts.app')

@section('content')
    <div class="container">
        <h1>Lista de Proviene Productos</h1>
        <a href="{{ route('proviene-producto.create') }}" class="btn btn-primary">Crear Proviene Producto</a>

        <table class="table mt-4">
            <thead>
                <tr>
                    <th>Dirección</th>
                    <th>Descripción</th>
                    <th>Estado</th>
                    <th>Origen</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($provieneProductos as $provieneProducto)
                    <tr>
                        <td>{{ $provieneProducto->direccion }}</td>
                        <td>{{ $provieneProducto->descripcion }}</td>
                        <td>{{ $provieneProducto->estado ? 'Activo' : 'Inactivo' }}</td>
                        <td>{{ $provieneProducto->origen }}</td>
                        <td>
                            <a href="{{ route('proviene-producto.edit', $provieneProducto->id_proviene_producto) }}" class="btn btn-warning">Editar</a>
                            <form action="{{ route('proviene-producto.destroy', $provieneProducto->id_proviene_producto) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <!-- Paginación -->
        {{ $provieneProductos->links() }}
    </div>
@endsection
