@extends('layouts.app')

@section('content')
    <div class="container">
        <h1>Editar Proviene Producto</h1>

        <form action="{{ route('proviene-producto.update', $provieneProducto->id_proviene_producto) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label for="direccion">Dirección</label>
                <input type="text" name="direccion" id="direccion" class="form-control" value="{{ $provieneProducto->direccion }}" required>
            </div>
            <div class="form-group">
                <label for="descripcion">Descripción</label>
                <textarea name="descripcion" id="descripcion" class="form-control" required>{{ $provieneProducto->descripcion }}</textarea>
            </div>
            <div class="form-group">
                <label for="estado">Estado</label>
                <select name="estado" id="estado" class="form-control" required>
                    <option value="1" {{ $provieneProducto->estado == 1 ? 'selected' : '' }}>Activo</option>
                    <option value="0" {{ $provieneProducto->estado == 0 ? 'selected' : '' }}>Inactivo</option>
                </select>
            </div>
            <div class="form-group">
                <label for="origen">Origen</label>
                <input type="text" name="origen" id="origen" class="form-control" value="{{ $provieneProducto->origen }}" required>
            </div>
            <button type="submit" class="btn btn-success mt-3">Actualizar</button>
        </form>
    </div>
@endsection
