<!-- resources/views/productos/index.blade.php -->
@extends('layouts.app')

@section('content')
    <div class="container">
        <h1>Productos</h1>

        <a href="{{ route('productos.create') }}" class="btn btn-primary mb-3">Crear Producto</a>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <table class="table">
            <thead>
                <tr>
                    <th>Cod. Producto</th>
                    <th>Cod. Tipo  Producto</th>

                    <th>Descripción</th>
                    <th>Cantidad</th>
                    <th>Fecha de Caducidad</th>
                    <th>Mantenimiento</th>
                    <th>Tipo Producto</th>
                    <th>Departamento</th>
                    <th>Proviene Producto</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                @foreach($productos as $producto)
                    <tr>
                        <td>{{ $producto->id_producto }}</td>
                        <td>{{ $producto->tipoProducto->id_tipo }}</td>

                        <td>{{ $producto->descripcion }}</td>
                        <td>{{ $producto->cantidad }}</td>
                        <td>{{ $producto->fecha_caducidad }}</td>
                        <td>{{ $producto->mantenimiento }}</td>
                        <td>{{ $producto->tipoProducto->descripcion }}</td>
                        <td>{{ $producto->departamento->descripcion }}</td>
                        <td>{{ $producto->provieneProducto->descripcion }}</td>
                        <td>{{ $producto->estado ? 'Activo' : 'Inactivo' }}</td>
                        <td>
                            <a href="{{ route('productos.edit', $producto->id_producto) }}" class="btn btn-warning btn-sm">Editar</a>
                            <form action="{{ route('productos.destroy', $producto->id_producto) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        {{ $productos->links() }}
    </div>
@endsection
