@extends('layouts.app')

@section('content')
<form action="{{ route('productos.store') }}" method="POST" enctype="multipart/form-data">
    @csrf

    <div class="form-group">
        <label for="descripcion">Descripción</label>
        <input type="text" class="form-control" id="descripcion" name="descripcion" required>
    </div>

    <div class="form-group">
        <label for="cantidad">Cantidad</label>
        <input type="number" class="form-control" id="cantidad" name="cantidad" required>
    </div>

    <div class="form-group">
        <label for="fecha_caducidad">Fecha de Caducidad</label>
        <input type="date" class="form-control" id="fecha_caducidad" name="fecha_caducidad" >
    </div>

    <div class="form-group">
        <label for="mantenimiento">Mantenimiento</label>
        <input type="text" class="form-control" id="mantenimiento" name="mantenimiento">
    </div>

    <div class="form-group">
        <label for="id_tipoproducto">Tipo de Producto</label>
        <select class="form-control" id="id_tipoproducto" name="id_tipoproducto" required>
            @foreach($tiposProductos as $tipoProducto)
                <option value="{{ $tipoProducto->id_tipo }}">{{ $tipoProducto->tipo }}</option>
            @endforeach
        </select>
    </div>

    <div class="form-group">
        <label for="id_departamento">Departamento</label>
        <select class="form-control" id="id_departamento" name="id_departamento" required>
            @foreach($departamentos as $departamento)
                <option value="{{ $departamento->id_departamento }}">{{ $departamento->descripcion }}</option>
            @endforeach
        </select>
    </div>

    <div class="form-group">
        <label for="id_proviene_producto">Proviene Producto</label>
        <select class="form-control" id="id_proviene_producto" name="id_proviene_producto" required>
            @foreach($provieneProductos as $provieneProducto)
                <option value="{{ $provieneProducto->id_proviene_producto }}">{{ $provieneProducto->descripcion }}</option>
            @endforeach
        </select>
    </div>

    <div class="form-group">
        <label for="estado">Estado</label>
        <select class="form-control" id="estado" name="estado" required>
            <option value="1">Activo</option>
            <option value="0">Inactivo</option>
        </select>
    </div>

    <div class="form-group">
        <label for="imagen">Imagen</label>
        <input type="file" class="form-control" id="imagen" name="imagen" accept="image/*" required>
    </div>

    <button type="submit" class="btn btn-success mt-3">Crear Producto</button>
</form>

@endsection
