@extends('layouts.app')

@section('content')
<div class="container">
    <h2 class="mb-4">Lista de Departamentos</h2>
    <a href="{{ route('departamentos.create') }}" class="btn btn-primary mb-3">Nuevo Departamento</a>
    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Descripción</th>
                <th>Estado</th>
                <th>Sucursal </th>
                <th>Sucursal Ubicacion </th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($departamentos as $departamento)
            <tr>
                <td>{{ $departamento->id_departamento }}</td>
                <td>{{ $departamento->descripcion }}</td>
                <td>{{ $departamento->estado ? 'Activo' : 'Inactivo' }}</td>
                <td>{{  $departamento->sucursal->descripcion ?? 'Sin Sucursal' }}</td>

                <td>{{ $departamento->sucursal->ubicacion ?? 'Sin ubicacion' }}</td>
                <td>
                    <a href="{{ route('departamentos.edit', $departamento->id_departamento) }}" class="btn btn-warning btn-sm">Editar</a>
                    <form action="{{ route('departamentos.destroy', $departamento->id_departamento) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm">Eliminar</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    {{ $departamentos->links() }}
</div>
@endsection
