@extends('layouts.app')

@section('title', 'Editar Departamento')

@section('content')
<div class="container">
    <h2>Editar Departamento</h2>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
<form action="{{ route('departamentos.update', ['departamento' => $departamento->id_departamento]) }}" method="POST">
    @csrf
    @method('PUT')

    <div class="form-group">
        <label for="descripcion">Descripción</label>
        <input type="text" name="descripcion" id="descripcion" class="form-control" value="{{ old('descripcion', $departamento->descripcion) }}" required>
    </div>

    <div class="form-group">
        <label for="estado">Estado</label>
        <select name="estado" id="estado" class="form-control">
            <option value="1" {{ $departamento->estado == 1 ? 'selected' : '' }}>Activo</option>
            <option value="0" {{ $departamento->estado == 0 ? 'selected' : '' }}>Inactivo</option>
        </select>
    </div>

    <div class="form-group">
        <label for="id_sucursal">Sucursal</label>
        <select name="id_sucursal" id="id_sucursal" class="form-control">
            @foreach($sucursales as $sucursal)
                <option value="{{ $sucursal->id_sucursal }}" {{ $departamento->id_sucursal == $sucursal->id_sucursal ? 'selected' : '' }}>
                    {{ $sucursal->descripcion }}
                </option>
            @endforeach
        </select>
    </div>

    <button type="submit" class="btn btn-primary">Actualizar</button>
</form>
@endsection
