/* 
 * Archivo que contiene todas las validaciones disponibles para las pï¿½ginas
 * 
 */

function validarRuc(ruc)
{
    var ruc_ = ruc;

    if(ruc_ != '810743542RC0001')
    {
        if ((ruc_ == "") || (ruc_ == 0)) {
            alert("Por Favor ingrese un RUC");
            return false;
        }

        if (ruc_.length < 13) {
            alert('Por favor ingrese un Ruc v\xE1lido');
            return false;
        }
        
        //Los tres \uFAltimos d\uE1EDgitos no tienen el cï¿½digo del RUC 001.
        while (ruc_.substring(10, 13) != 001) {
            alert('Por favor ingrese un Ruc v\xE1lido');
            return false;
        }
        //Los dos primeros d\uEDgitos no pueden ser mayores a 24.
        while (ruc_.substring(0, 2) > 24) {
            alert('Por favor ingrese un Ruc v\xE1lido');
            return false;
        }
    }    
        
    return true;
}



function es_cedula_valida(cedula) //La variable cedula debe ser un string con los 10 numeros de la c?dula
{
    if (cedula === '0961686060') {
        return true;
    }
    valido = false;

    if (cedula.length == 10) {
        var nroRegion = parseInt(cedula.substr(0, 2), 10);

        //verificamos las 24 provincias del Ecuador 	
        /*Resoluciï¿½n 140 del Registro Civil publicada en el Registro Oficial No. 681, con fecha 12
         de abril de 2012, donde resuelve en su artï¿½culo 1: ï¿½Disponer la creaciï¿½n del cï¿½digo inicial
         No. 30 (TREINTA) ï¿½Exteriorï¿½, para ser utilizado por los consulados ecuatorianos, en la
         inscripciï¿½n de nacimiento al asignar el nï¿½mero de cï¿½dula definitiva de identificaciï¿½n de
         las ecuatorianas y los ecuatorianos nacidos en el exteriorï¿½ï¿½.*/
        if ((nroRegion >= 1 && nroRegion <= 24) || nroRegion == 30)
         /*   if (parseInt(cedula.charAt(2), 10) < 6) //verificamos que el 3 digito que sea menor a 6
            {*/
                suma = num_val(cedula.charAt(0)) +
                        parseInt(cedula.charAt(1), 10) +
                        num_val(cedula.charAt(2)) +
                        parseInt(cedula.charAt(3), 10) +
                        num_val(cedula.charAt(4)) +
                        parseInt(cedula.charAt(5), 10) +
                        num_val(cedula.charAt(6)) +
                        parseInt(cedula.charAt(7), 10) +
                        num_val(cedula.charAt(8));
                residuo = suma % 10;
                if (residuo > 0)
                    digito_verificador = 10 - residuo
                else
                    digito_verificador = 0;    // Obtenemos el d?gito verificador
                valido = (digito_verificador == parseInt(cedula.charAt(9), 10)); //Comprobamos el d?gito verificador con el ingresado
            //}
    }
    return(valido);
}


function validacombobox(cb) {
    if (cb.value == -1)
        return false
    else
        return true;
}

function validaedit(campo) {
    if (campo.value == '')
        return false
    else
        return true;
}


function verificaradiocheck(campo) {
    verifica = false;
    var i
    for (i = 0; i < campo.length; i++) {
        if (campo[i].checked) {
            verifica = true;
            break;
        }
    }
    return verifica;
}

function verificaradiocheck1(campo) {
    verifica = -1;
    var i
    for (i = 0; i < campo.length; i++) {
        if (campo[i].checked) {
            verifica = campo[i].value;
            break;
        }
    }
    return verifica;
}

function limpiaradiocheck(campo) {
    var i
    for (i = 0; i < campo.length; i++) {
        if (campo[i].checked) {
            campo[i].checked = false;
        }
    }
}

function valida_porcentaje(campo) {
    valido = false;
    if (isNaN(campo.value)) {
        campo.value = ""
        campo.focus();
    }
    else
    {
        if (campo.value.length == 2)
        {
            if (parseInt(campo.value) < 10) {
                alert("El porcentaje es incorrecto");
                campo.value = "";
                campo.focus();
            }
        }
        else if (campo.value.length > 2) {
            campo.value = campo.value.substr(0, 2);
            campo.focus();
        }
        else
            valido = true;
    }
    return(valido);
}

function valida_numero(campo, limite) {
    valido = false;
    if (isNaN(campo.value)) {
        campo.value = ""
        campo.focus();
    }
    else
    {
        if (campo.value.length > limite) {
            campo.value = campo.value.substr(0, limite);
            campo.focus();
        }
        else
            valido = true;
    }
    return(valido);
}

function valida_numero_mm(campo, min, max) {
    valido = false;
    if (isNaN(campo.value) || (campo.value < min) || (campo.value > max)) {
        campo.value = ""
        campo.focus();
    }
    else
    {
        valido = true;
    }
    return(valido);
}

function valida_numero_mp(campo, min, max) {

    valido = false;
    if (!/^([0-9])*$/.test(campo.value))
    {
        alert("Por favor ingrese unicamente numeros.");
        campo.value = "";
        campo.focus();
        return false;
    }

    if (isNaN(campo.value) || (campo.value < min) || (campo.value > max)) {
        campo.value = ""
        campo.focus();
    }
    else
    {
        valido = true;
    }
    return(valido);


}

function soloNumeros(evt, numero)
{
    evt = (evt) ? evt : event;
    var charCode = (evt.charCode) ? evt.charCode : ((evt.keyCode) ? evt.keyCode : ((evt.which) ? evt.which : 0));
    var respuesta = true;
    //caracteres que acepta
    if ((charCode < 48 || charCode > 57) && (charCode != 46) && (charCode != 127) && (charCode != 08) && (charCode != 37) && (charCode != 39) && (charCode != 09))
    {
        respuesta = false;
    }
    return respuesta;
}

function verifica_check_gap(campo, valor, pobre) {

    var gapUnaCondicion = [9, 12, 13, 59, 60, 10, 11, 21, 17, 61, 62];//array con los gap_id de 1 condici?n 
    var gapDosCondicion = [8, 63, 14, 64, 7, 6, 65, 66, 16, 15, 22];   //array con los gap_id de 2 condiciones 

    //si es pobre une los dos arrays.
    if (pobre)
        var gapUnaCondicion = gapUnaCondicion.concat(gapDosCondicion);

    //n?mero de gaps seleccionados.
    cantidad = get_cant_check(campo);

    //obtiene gap seleccionado.
    indice = get_indice_check(campo, valor);

    //si no est? seleccionada ninguna opci?n
    if (cantidad == 0)
    {
        for (i = 0; i < campo.length; i++)
            if (campo[i].value != valor)
                campo[i].disabled = false;
    }

    //verifica una condici?n de vulnerabilidad
    else if (cantidad == 1)
    {
        res = $.inArray(valor, gapUnaCondicion);
        if (res >= 0)// si est? dentro del 1 grupo
        {
            if (campo[indice].checked)
            {
                for (i = 0; i < campo.length; i++)
                    if (campo[i].value != valor) {
                        campo[i].disabled = true;
                    }
            }
            else
            {
                for (i = 0; i < campo.length; i++)
                    if (campo[i].value != valor)
                        campo[i].disabled = false;
            }
        }
        else
        {
            for (i = 0; i < campo.length; i++)
                campo[i].disabled = false;
        }
    }

    ////verifica dos condici?nes de vulnerabilidad	
    else if (cantidad == 2)
    {
        res = $.inArray(valor, gapDosCondicion);
        if (res >= 0)// si est? dentro del 2 grupo
        {
            for (i = 0; i < campo.length; i++)
                if (!campo[i].checked)
                    campo[i].disabled = true;
        }
    }

}

function get_indice_check(campo, valor) {
    var i;
    for (i = 0; i < campo.length; i++) {
        if (campo[i].value == valor) {
            return(i);
            break;
        }
    }
}

function get_cant_check(campo) {
    var i;
    n = 0;
    for (i = 0; i < campo.length; i++) {
        if (campo[i].checked) {
            n = n + 1;
        }
    }
    return(n);
}

function get_array_check(campo) {
    var lista = new Array();
    var i;
    n = 0;
    for (i = 0; i < campo.length; i++) {
        if (campo[i].checked) {
            lista[n] = campo[i].value;
            n = n + 1;
        }
    }
    return(lista);
}

function get_gratis_check(c1, c2, pobre) {
    gratis = false;
    if ((((c1 >= 8) && (c1 <= 13)) || (c1 == 17) || (c1 == 21)) || ((((c2 >= 8) && (c2 <= 13)) || (c2 == 17) || (c2 == 21)))) {
        gratis = true;
    }
    else if ((((c1 >= 1) && (c1 <= 7)) || ((c1 >= 14) && (c1 <= 16)) || ((c1 >= 18) && (c1 <= 20))) || (((c1 >= 1) && (c1 <= 7)) || ((c1 >= 14) && (c1 <= 16)) || ((c1 >= 18) && (c1 <= 20)))) {
        gratis = true;
    }
    else if (pobre) {
        if ((c1 == 22) || (c2 == 22)) {
            gratis = true;
        }
        if ((((c1 >= 1) && (c1 <= 7)) || ((c1 >= 14) && (c1 <= 16)) || ((c1 >= 18) && (c1 <= 20))) || (((c1 >= 1) || (c1 <= 7)) || ((c1 >= 14) && (c1 <= 16)) || ((c1 >= 18) && (c1 <= 20)))) {
            gratis = true;
        }
    }

    return(gratis);
}

function validarMail(valor) {
    //if (/[\w-\.]{3,}@([\w-]{2,}\.)*([\w-]{2,}\.)[\w-]{2,4}/.test(valor)) {

    // \w valida que tenga una palabra
    if (/^([\w-\.]+@([\w-]+\.)+[\w-]{2,6})?$/.test(valor)) {
        return true;
    }
    else {
        return false;
    }

}




function validarMailInstitucional(campo)
{
    if (validarEmail(campo))
    {
        var aux = (campo.value).split('@');
        if (aux[1] == 'secap.gob.ec')
            return true;
        else
        {
            alert("Por favor ingrese un e-mail institucional. Ejm:  mail@secap.gob.ec");
            campo.value = "";
            campo.focus();
            return false;
        }
    }
    else
        return false;
}

//funcion para control que sea solo n?meros
function validarNumero(numero) {
    if (!/^([0-9])*$/.test(numero.value))
    {
        alert("Por favor ingrese unicamente numeros.");
        numero.value = "";
        numero.focus();
        return false;
    }
    else
    {
        return true;
    }
}

//funcion para control que sea solo n?meros
function validarDecimal(numero) {
    if (!/^([0-9.])*$/.test(numero.value))
    {
        alert("Por favor ingrese un nï¿½mero decimal vï¿½lido");
        numero.value = "";
        numero.focus();
        return false;
    }
    else
    {
        return true;
    }
}

//funcion para control de longitud de un campo
function validarLongitud(campo, longitud, detalle) {
    if (campo.length < longitud)
    {
        alert("El campo " + detalle + " debe contener mï¿½nimo " + longitud + " caracteres");
        return false;
    }
    else
    {
        return true;
        //validarRepeticionCaracteres(campo,longitud,detalle) 
    }
}



//funcion que valida si un string es un n?mero el cual puede ser decimal o con separador de miles
function validarSiNumero(numero)
{
    if (!/^([0123456789.,])*$/.test(numero))
        return false;
    else
        return true;
}

function validarLetras(valor)
{
    if (!/^[a-zA-Zï¿½ï¿½ï¿½ï¿½ï¿½Aï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ ]+$/.test(valor.value))
    {
        alert("Ingrese solo letras");
        valor.value = ""
        valor.focus();
    }
}

function validarDireccion(valor)
{
    if (!/^[a-zA-Zï¿½ï¿½ï¿½ï¿½ï¿½Aï¿½ï¿½ï¿½ï¿½ï¿½ï¿½0-9 -]*$/.test(valor.value))
    {
        valor.value = "";
        alert("Ingrese \xFAnicamente letras y n\xFAmeros");
        valor.focus();
    }
    else
        return true;
}

//Funcion validar los caracteres minimos de un numero celular
function validarMinNumeroCelular(numero, valorMinimo)
{
    if (numero.length < valorMinimo)
    {
        alert('El n\xFAmero celular debe tener como minimo 10 dï¿½gitos');
        return false;
    }
    else
    {
        return true;
    }
}

//Funcion validar los caracteres minimos de un numero convencional
function validarMinNumeroFijo(numero, valorMinimo)
{
    if (numero.length < valorMinimo)
    {
        alert('El nï¿½mero fijo debe tener como mï¿½nimo 9 dï¿½gitos.');
        return false;
    }
    else
    {
        return true;
    }
}

//Funcion validar min de caracteres para la c?dula
function validarMinCed(numero, valorMinimo)
{

    //alert(numero);
    //alert(valorMinimo);
    if (numero.length < valorMinimo)
    {
        numero.value = ""
        //numero.focus();
        alert('El nï¿½mero de dï¿½gitos de la cï¿½dula es incorrecto');
        return false;
    }
    else
    {
        return true;
    }
}


//Funcion que permite el ingreso de solamente n?meros
function soloNumeros(evt) {
    //asignamos el valor de la tecla a keynum
    if (window.event) {// IE
        keynum = evt.keyCode;

    }
    else {
        keynum = evt.which;
    }

    //comprobamos si se encuentra en el rango
    if ((keynum > 47 && keynum < 58) || keynum == 8 || keynum == 11 || keynum == 0) {
        return true;
    }
    else {
        return false;
    }
}


function num_val(numero)
{
    numero = numero * 2;
    if (numero >= 10)
        numero = numero - 9;
    return(numero);
}

function numbersonly(myfield, e, dec) {

    var key;
    var keychar;

    if (window.event)
        key = window.event.keyCode;

    else if (e)
        key = e.which;
    else
        return true;
    keychar = String.fromCharCode(key);

// control keys
    if ((key == null) || (key == 0) || (key == 8) ||
            (key == 9) || (key == 13) || (key == 27))
        return true;
// numbers
    else if ((("0123456789").indexOf(keychar) > -1))
        return true;
// decimal point jump
    else if (dec && (keychar == "."))
    {
        myfield.form.elements[dec].focus();
        return false;
    }
    else
        return false;
}

//funcion para validar que la clave cotenga mï¿½ni 6 y maximo 15 caracteres entre letras y nï¿½meros

function validarClave(clave)
{
    if (clave === "") {
        alert("Por favor ingrese una clave");
        return false;
    }
    var tam = clave.length;
    //se verifica tamaï¿½o de la clave
    if ((tam >= 6) && (tam <= 15))
    {
        if (contieneNumeros(clave))
        {
            if (contieneLetras(clave))
                return true;
            else
            {
                alert("La contrase\xF1a debe contener letras adem\xE1s de n\xFAmeros");
                return false;
            }
        }
        else
        {
            alert("La contrase\xF1a debe contener n\xFAmeros adem\xE1s de letras");
            return false;
        }
    }
    else
    {
        alert("La contrase\xF1a debe ser de m\xEDnimo 6 caracteres y m\xE1ximo 15");
        return false;
    }
}

//verifica si un texto contiene nï¿½meros
function contieneNumeros(texto) {
    var numeros = "0123456789";
    for (i = 0; i < texto.length; i++) {
        if (numeros.indexOf(texto.charAt(i), 0) !== -1) {
            return true;
        }
    }
    return false;
}


//verifica si un texto contiene letras
function contieneLetras(texto) {
    var letras = "ABCDEFGHIJKLMN\xD1OPQRSTUVWXYZabcdefghijklmn\xF1opqrstuvwxyz";
    for (i = 0; i < texto.length; i++) {
        if (letras.indexOf(texto.charAt(i), 0) !== -1) {
            return true;
        }
    }
    return false;
}

//funcion para validacion de numeros reales AP
function validarFloat(myfield, e) {
    var key;
    var valor = myfield.value;
    var esflotante = 0;
    if (window.event)
        key = window.event.keyCode;
    else if (e)
        key = e.which;

    for (var i = 0; i <= valor.length; i++) {
        if (valor.indexOf('.') !== -1)
            esflotante = esflotante + 1;
    }

    //Control para evitar que se ingrese mas de 1 punto decimal
    if (esflotante > 1 && key === 46)
        return false;

    //Valores ascii de lo caracteres permitidos para el ingreso
    if ((key > 47 && key < 58) || key === 8 || key === 11 || key === 0 || key === 46) {
        return true;
    } else {
        return false;
    }
}
function validarIp(myfield, e) {
    var key;
    var valor = myfield.value;
    var esflotante = 0;
    if (window.event)
        key = window.event.keyCode;
    else if (e)
        key = e.which;

    for (var i = 0; i <= valor.length; i++) {
        if (valor[i] === '.')
            esflotante = esflotante + 1;

    }
//alert(esflotante);
    //Control para evitar que se ingrese mas de 1 punto decimal
    if (parseInt(esflotante) >= 3 && key === 46) {
        return false;
    }

    //Valores ascii de lo caracteres permitidos para el ingreso
    if ((key > 47 && key < 58) || key === 8 || key === 11 || key === 0 || key === 46) {
        return true;
    } else {
        return false;
    }
}

function letrasynumeros(e) {
    var tecla = (document.all) ? e.keyCode : e.which;
    if (tecla === 0 || tecla === 8 || tecla === 32 || tecla === 241 || tecla === 209 || tecla === 225 || tecla === 233 || tecla === 237 ||
            tecla === 243 || tecla === 250 || tecla === 193 || tecla === 201 || tecla === 205 || tecla === 211 || tecla === 218)
        return true;
    var patron = /[0-9A-Za-z]/;
    var te = String.fromCharCode(tecla);
    return patron.test(te);
}

//funcion para validar telefono convencional
function validarTelefono(telefono, tamano)
{

    valor = telefono.value
    error = "";
    if (valor == "")
        error = "Ingrese un telï¿½fono vï¿½lido";
    if ((valor.length < tamano) || (valor.length > tamano))
        error = "Ingrese un telï¿½fono vï¿½lido";
    if (!/^([0123456789])*$/.test(valor))
        error = "Ingrese solo nï¿½meros";
    if (contarCaracteresSecuenciales(valor) == tamano)
        error = "Ingrese un telï¿½fono vï¿½lido";

    if (error != '')
    {
        alert(error);
        $('#' + telefono.id).val('');
        $('#' + telefono.id).focus();
        return false;
    }
    else
        return true;
}

function contarCaracteresSecuenciales(dato)
{
    contador = 1;
    caracterAnt = dato.substring(0, 1);
    for (i = 1; i < dato.length; i++)
    {
        if (dato.substring(i, (i + 1)) == caracterAnt)
            contador++;
        else {
            contador = 1
        }
        caracterAnt = dato.substring(i, (i + 1));
    }
    return contador;
}

function compara_fechas(fecha, fecha2) {
    //valores retornados
    //1 fecha es mayor a fecha2
    //0 las fechas son iguales
    //-1 fecha es menor a fecha2
    var es_mayor = -1;
    var xMonth = fecha.substring(5, 7);
    var xDay = fecha.substring(8, 10);
    var xYear = fecha.substring(0, 4);
    var yMonth = fecha2.substring(5, 7);
    var yDay = fecha2.substring(8, 10);
    var yYear = fecha2.substring(0, 4);

    if (xYear > yYear) {
        es_mayor = 1;
    } else if (xYear === yYear) {
        if (xMonth > yMonth) {
            es_mayor = 1;
        } else if (xMonth === yMonth) {
            if (xDay > yDay) {
                es_mayor = 1;
            } else if (xDay === yDay) {
                es_mayor = 0;
            }
        }
    }
    return es_mayor;
}

function varios_enteros(myfield, e, dec) {

    var key;
    var keychar;

    if (window.event) {
        key = window.event.keyCode;
    } else if (e) {
        key = e.which;
    } else {
        return true;
    }

    keychar = String.fromCharCode(key);

// control keys
    if ((key == null) || (key == 0) || (key == 8) ||
            (key == 9) || (key == 13) || (key == 27) || (key == 32) || (key == 44)) {
        return true;
// numbers
    } else if ((("0123456789").indexOf(keychar) > -1)) {
        return true;
    } else if (dec && (keychar == ".")) {
        // decimal point jump
        myfield.form.elements[dec].focus();
        return false;
    } else {
        return false;
    }
}

function uppercasecad(campo) {
    campo.value = campo.value.toUpperCase();
}

function ingresaDescripcion(e) {
    var tecla = (document.all) ? e.keyCode : e.which;
    if (tecla === 0 || tecla === 8 || tecla === 32 || tecla === 45 || tecla === 241 || tecla === 209 || tecla === 225 || tecla === 233 || tecla === 237 ||
            tecla === 243 || tecla === 250 || tecla === 193 || tecla === 201 || tecla === 205 || tecla === 211 || tecla === 218)
        return true;
    var patron = /[0-9A-Za-z]/;
    var te = String.fromCharCode(tecla);
    return patron.test(te);
}

//permite el ingreso ï¿½nicamente de letras
//el parï¿½metro recibido debe ser event
function lettersonly(e) {
    var tecla = (document.all) ? e.keyCode : e.which;
    if (tecla === 0 || tecla === 8 || tecla === 32)
        return true;
    var patron = /[A-Za-z]/;
    var te = String.fromCharCode(tecla);
    return patron.test(te);
}

/*Darwin Meneses 2014-10-21==========================*/
//verifica si existen un numero definido de caracteres repetidos, devuleve un booleano dato=texto a verificar, numRepeticiones = numero de repeticiones a verificar
function verificarCaracteresSecuenciales(dato, numRepeticiones)
{
    contador = 1;
    caracterAnt = dato.substring(0, 1);
    for (i = 1; i < dato.length; i++)
    {
        if (dato.substring(i, (i + 1)) === caracterAnt)
            contador++;
        else {
            contador = 1;
        }
        caracterAnt = dato.substring(i, (i + 1));
        if (contador >= numRepeticiones) {
            return true;
        }
    }
    return false;
}

function validarEmail(campo)
{
    error = "";
    mail = campo.value;

    if (mail === "") {
        error += " mail vacio";
    }

    if (!validarMail(mail)) {
        error += " mail incorrecto";
    }

    if (verificarCaracteresSecuenciales(mail, 4)) {
        error += " 4 caracteres repetidos";
    }

    var palabrasNoPermitidas = ['sincorreo', 'nodispone', 'usuario', 'cm.loja', 'noregistra', 'co.galapagos', 'notiene'];

    $.each(palabrasNoPermitidas, function (key, value) {
        if (mail.indexOf(value) >= 0) {
            error += " palabra no permitida";
        }
    });

    if (error !== "")
    {
        alert("Por favor ingrese un mail v\xE1lido.");
        campo.value = "";
        campo.focus();
        return false;
    }
    else
    {
        return true;
    }
}
/*Darwin Meneses 2014-10-21==========================*/

//FUNCIONES OFICIALES
/*=======================================================================*/
//2014-10-28
//
//Valida que se ingrese solo letras acepta mayï¿½culas, minï¿½sculas y ï¿½ï¿½}
//forma de uso  onkeypress="return alpha(event);"
function alpha(e) {
    var key = (document.all) ? e.keyCode : e.which;
    var valid = [0, 8, 32];
    var value = false;
    for (var i in valid) {
        if (key === valid[i]) {
            value = true;
            break;
        }
    }
    if (value === true) {
        return true;
    } else {
        var pattern = /[A-Za-zï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½\xE1\xE9\xED\xF3\xFA\xC1\xC9\xCD\xD3\xDA\xF1\xD1]/;
        var te = String.fromCharCode(key);
        return pattern.test(te);
    }
}

//2014-10-28
//
//Valida que se ingrese solo nï¿½meros
//forma de uso  onkeypress="return numeric(event);"
function numeric(e) {
    var key = (document.all) ? e.keyCode : e.which;
    var valid = [0, 8, 32];
    var value = false;
    for (var i in valid) {
        if (key === valid[i]) {
            value = true;
            break;
        }
    }

    if (value === true) {
        return true;
    } else {
        var pattern = /[\d]/;
        var te = String.fromCharCode(key);
        return pattern.test(te);
    }
}

//2014-10-28
//
//Valida que se ingrese solo letras y nï¿½meros
//forma de uso  onkeypress="return alphanumeric(event);"
function alphanumeric(e) {
    var key = (document.all) ? e.keyCode : e.which;
    var valid = [0, 8, 32];
    var value = false;
    for (var i in valid) {
        if (key === valid[i]) {
            value = true;
            break;
        }
    }

    if (value === true) {
        return true;
    } else {
        var pattern = /[0-9A-Za-zï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½\xE1\xE9\xED\xF3\xFA\xC1\xC9\xCD\xD3\xDA\xF1\xD1]/;
        var te = String.fromCharCode(key);
        return pattern.test(te);
    }
}

//2014-10-28
//
//Valida que se ingrese solo los caractes permitidos
//forma de uso  onkeypress="return validchars(event);"
function validchars(e) {
    var key = (document.all) ? e.keyCode : e.which;
    var valid = [0, 8, 32];
    var value = false;
    for (var i in valid) {
        if (key === valid[i]) {
            value = true;
            break;
        }
    }

    if (value === true) {
        return true;
    } else {
        var pattern = /[A-Za-z0-9ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½ï¿½\xE1\xE9\xED\xF3\xFA\xC1\xC9\xCD\xD3\xDA\xF1\xD1\-_,;.:\/\\@\*\!ï¿½ï¿½?\(\)=$%&#]/;
        var te = String.fromCharCode(key);
        return pattern.test(te);
    }
}

//2015-06-02  DM
//
//Valida que se ingrese codigos de cursos separados por comas
//forma de uso  onkeypress="return validCourseCode(event);"
function validCourseCode(e) {
    var key = (document.all) ? e.keyCode : e.which;
    var valid = [0, 8, 32];
    var value = false;
    for (var i in valid) {
        if (key === valid[i]) {
            value = true;
            break;
        }
    }

    if (value === true) {
        return true;
    } else {
        var pattern = /[0-9,]/;
        var te = String.fromCharCode(key);
        return pattern.test(te);
    }
}

function validarPasaporte(pasaporte)
{
    var error = "";
    if (verificarCaracteresSecuenciales(pasaporte, 6)) {
        error += "Caracteres repetidos";
    }
    if (pasaporte.length < 6) {
        error += "no cumple longitud minima";
    }

    if (error !== "")
    {
        alert("Por favor ingrese un pasaporte v\xE1lido");
        return false;
    }
    else
    {
        return true;
    }
}

//funciï¿½n que valida un numero de identificacion segï¿½n su tipo, cedula,pasaporte,ruc,
//recibe el tipo y numero de identificacion,devuleve un booleano.
//el elemento que contien el numero de identificacion en la pagina se debe llamar numeroIdentificacion por defecto
function validarNumeroIdentificacion(tipoIdentificacion, numeroIdentificacion)
{
    if (numeroIdentificacion === "") {
        alert("Por favor ingrese un n\xFAmero de documento");
        $('#numeroIdentificacion').val("");
        $('#numeroIdentificacion').focus();
        return false;
    }

    switch (tipoIdentificacion)
    {
        case "1":
            if (!es_cedula_valida(numeroIdentificacion)) {
                alert("Ingrese una c\xE9dula correcta");
                $('#numeroIdentificacion').val("");
                $('#numeroIdentificacion').focus();
                return false;
            }
            break;
        case "2":

            if (!validarPasaporte(numeroIdentificacion)) {
                $('#numeroIdentificacion').val("");
                $('#numeroIdentificacion').focus();
                return false;
            }
            break;
        case "5":
            if (!validarRuc(numeroIdentificacion)) {
                $('#numeroIdentificacion').val("");
                $('#numeroIdentificacion').focus();
                return false;
            }
            break;
    }
    return true;
}

//funcion que permite el calculo de la edad en realciï¿½n a una fecha inicial en formato aaaa-mm-dd, y la fecha de nacimiento en formato aaaa-mm-dd
function calculaEdad(fechaInicio, fechaNacimiento) {
//Variables para el calculo de la edad  
    var array_fecha = fechaNacimiento.split("-");
    var array_inicio = fechaInicio.split("-");
    var hoy_anio = parseInt(array_inicio[0], 10);
    var hoy_mes = parseInt(array_inicio[0], 10);
    var hoy_dia = parseInt(array_inicio[2], 10);

    var nac_anio = parseInt(array_fecha[0], 10);
    var nac_mes = parseInt(array_fecha[1], 10);
    var nac_dia = parseInt(array_fecha[2], 10);

    //Calculo la edad
    edad = hoy_anio - nac_anio;
    meses_diff = (hoy_mes + 1) - nac_mes;
    dias_diff = hoy_dia - nac_dia;

    if (meses_diff < 0)
    {
        edad--;
    }
    else if ((meses_diff == 0) && (dias_diff < 0))
    {
        edad--;
    }
    return edad;
}

