document.getElementById('usuario').addEventListener('keydown', inputCharacters);
document.getElementById('clave').addEventListener('keydown', inputCharacters);

function inputCharacters(event) {

    if (event.keyCode == 13) {
        login();
    }

}

function login() {
    $.post(ambiente + "/valida_usuario.php",
        $("#frmLogin").serialize(),
        function (rsLogin) {
            if (parseInt(rsLogin.response) === 1) {
                window.location.href = rsLogin.header;
            } else {
                loader_msg_warning(rsLogin.msg, 1, ambiente);
            }
        }, 'json');
}

function recuperarClave() {
    $('#divMain').hide();
    $('#divCambioClave').show();
}

async function buscaUsuario() {
    var usrId = $('#txtUsuario').val();
    loader_wait_msg("Por favor espere");
    let envioCodigo = await $.post(ambiente + "/login/json/enviarCodigo.php",
        {usrId},
        function (data) {
            loader_wait_msg_close();
        }, 'json');

    if (parseInt(envioCodigo.response) === 1) {
        $('#divMain').hide();
        $('#divCambioClave').hide();
        $('#divClaveTemp').show();
        $('#divCambioClaveSec').hide();
    } else {
        loader_msg_warning(envioCodigo.msg, 1, ambiente);
    }
}

function cambiarClave() {
    var codigo = $('#codigo').val();
    var password = $('#claveNueva').val();
    var confirm_password = $('#claveNuevaConf').val();

    $.post(ambiente + "/login/json/cambiarClave.php",
        {codigo, password, confirm_password},
        function (data) {
            if (parseInt(data.response) === 1) {
                loader_msg_ok(data.msg, 1, ambiente);
                setTimeout(function () {
                    window.location.href = ambiente + '/index.php';
                }, 2000);
            } else {
                loader_msg_warning(data.msg, 1, ambiente);
            }
        }, 'json');
}

