import React from 'react';
import { useLocation } from 'react-router-dom';
import { UpOutlined } from '@ant-design/icons'; // Importa el icono de Ant Design

const ScrollToTopButton = ({ homeRef }) => {
  const location = useLocation(); // Obtiene la ubicación actual

  const scrollToHome = () => {
    if (homeRef?.current) { // Verificamos que homeRef.current no sea null
      homeRef.current.scrollIntoView({ behavior: 'smooth' });
    }
  };

  // Solo mostrar el botón si estamos en la ruta '/'
  if (location.pathname !== '/') {
    return null; // Si no estamos en la página principal, no renderizamos el botón
  }

  return (
    <button
      onClick={scrollToHome}
      style={styles.button}
      aria-label="Scroll to top"
    >
      <UpOutlined style={{ fontSize: '2.2vw', color: 'red' }} />
    </button>
  );
};

const styles = {
  button: {
    position: 'fixed',
    bottom: '2rem',
    right: '1rem',
    backgroundColor: '#fff',
    border: 'none',
    borderRadius: '50%',
    width: '50px',
    height: '50px',
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    cursor: 'pointer',
    boxShadow: '0px 4px 10px rgba(176, 14, 14, 0.3)',
    transition: 'background-color 0.3s, transform 0.2s',
  },
  '@media (max-width: 768px)': {
    button: {
      width: '40px',
      height: '40px',
      bottom: '1.5rem',
      right: '5rem',
    }
  },
  '@media (max-width: 480px)': {
    button: {
      width: '35px',
      height: '35px',
      bottom: '1rem',
      right: '8rem',
    }
  }


};

export default ScrollToTopButton;
