import React, { useState } from 'react';

function RegistrationForm() {
  const [formData, setFormData] = useState({
    nombres: '',
    apellidos: '',
    email: '',
    telefono: '',
    club: '',
    fecha_nacimiento: '',
    identificacion: '',
    usuario: '',
  });

  const handleChange = (e) => {
    const { name, value } = e.target;
    setFormData({
      ...formData,
      [name]: value,
    });
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    // Aquí podrías agregar la lógica para enviar los datos al servidor
    try {
      const response = await fetch('/api/register', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify(formData),
      });
      const data = await response.json();
      console.log(data);
    } catch (error) {
      console.error('Error:', error);
    }
  };

  return (
    <form onSubmit={handleSubmit}>
      <input
        type="text"
        name="nombres"
        value={formData.nombres}
        onChange={handleChange}
        placeholder="Nombres"
        required
      />
      <input
        type="text"
        name="apellidos"
        value={formData.apellidos}
        onChange={handleChange}
        placeholder="Apellidos"
        required
      />
      <input
        type="email"
        name="email"
        value={formData.email}
        onChange={handleChange}
        placeholder="Correo Electrónico"
        required
      />
      <input
        type="tel"
        name="telefono"
        value={formData.telefono}
        onChange={handleChange}
        placeholder="Teléfono"
        required
      />
      <input
        type="date"
        name="fecha_nacimiento"
        value={formData.fecha_nacimiento}
        onChange={handleChange}
        required
      />
      <input
        type="text"
        name="identificacion"
        value={formData.identificacion}
        onChange={handleChange}
        placeholder="Identificación"
        required
      />
      <input
        type="text"
        name="usuario"
        value={formData.usuario}
        onChange={handleChange}
        placeholder="Usuario"
        required
      />
      <button type="submit">Enviar</button>
    </form>
  );
}

export default RegistrationForm;