import React, { useState, useEffect } from 'react';
import '../estilos/Navbar.css';


import foto1 from '../assets/logosApps/gggpoker.png';
import foto2 from '../assets/logosApps/pokerbross.png';
import foto3 from '../assets/logosApps/pppoker.png';
import foto4 from '../assets/logosApps/suprema2024.png';
import foto5 from '../assets/logosApps/LOGO X POKER.png';

import foto8 from '../assets/naipes/naipes.png';
import foto9 from '../assets/naipes/naipes alreves.png';

import Estrellas from './Estrellas';


const Navbar = () => {
    const images = [
        foto1,
        foto2,
        foto3,
        foto4,
        foto5,
    ];

    const [currentIndex, setCurrentIndex] = useState(0);

    useEffect(() => {
        const intervalId = setInterval(() => {
            setCurrentIndex((prevIndex) => (prevIndex + 1) % images.length);
        }, 15000);

        return () => clearInterval(intervalId);
    }, [images.length]);

    return (
        <header className="Navbar">
            <Estrellas />
            <div className="image-container">
                <div className="image-carousel">
                    {images.map((src, index) => (
                        <div className="logo-slider__slide" key={index}>
                            <img src={src} alt={`logo-${index}`} />
                        </div>
                    ))}
                </div>
            </div>


            <img src={foto9} alt="top-left" className="top-left-img" />


            <img src={foto8} alt="bottom-right" className="bottom-right-img" />
        </header>
    );
};

export default Navbar;
