import React from 'react';
import pru from '../assets/pru.png';
import foto from '../assets/mano-con-celular-mockup.png';  

import Marciano from './Marciano';

const Home = () => {
  
  const generateStars = (numStars) => {
    const stars = [];
    for (let i = 0; i < numStars; i++) {
      const x = Math.random() * 100; 
      const y = Math.random() * 100; 
      const size = Math.random() * 1 + 0.5; 
      const opacity = Math.random() * 0.6 + 0.4; 
      
      stars.push({ x, y, size, opacity });
    }
    return stars;
  };
  
  const containerStyle = {
  position: 'relative',
  width: '100%',
  height: '100vh',
  backgroundColor: 'black',
  backgroundImage: `url(${pru})`, 
  backgroundSize: 'cover',
  backgroundPosition: 'center',
  

};
  
  const starsStyle = {
    position: 'absolute',
    top: 0,
    left: 0,
    width: '100%',
    height: '100%',
    pointerEvents: 'none', 
  };

  const paragraphContainerStyle = {
    position: 'relative',
    top: '35%',
    left: '70%',
    transform: 'translateX(-75%)',
    color: 'white',
    textAlign: 'center',
    fontFamily: 'Calibri, sans-serif',
    fontSize: '10vw',
    height: '0%',
  };

  const paragraphStyle = {
    marginBottom: '20px',
  };

  const lastParagraphStyle = {
    marginBottom: '18px',

  };

  


  const stars = generateStars(200);
  return (
    <div style={containerStyle}>
      <div style={starsStyle}>
        {stars.map((star, index) => (
          <div
            key={index}
            style={{
              position: 'absolute',
              top: `${star.y}%`,
              left: `${star.x}%`,
              width: `${star.size}px`,
              height: `${star.size}px`,
              backgroundColor: 'yellow',
              borderRadius: '50%',
              opacity: star.opacity,
              boxShadow: `0 0 ${star.size * 2}px white`, 
            }}
          />
        ))}
      
      <div className="textoStyle">
  BIENVENIDO A <br className="mobileOnly"/> ECUAPOKER
</div>
        <p className="highlighted-paragraph">LA MEJOR COMUNIDAD DE POKER ONLINE</p>

        <div className='paragraphContainerStyle'>
          <p style={paragraphStyle} className="paragraphStyle">
            Únete a ECUAPOKER y descubre una plataforma
            segura y confiable para jugar poker
            en Ecuador. Disfruta de depósitos y retiros
            INMEDIATOS, soporte desde las 8:00 am hasta las
            2:00 am Ecuador, los 7 días de la semana, y una
            comunidad apasionada por el poker.
          </p>
          <p style={lastParagraphStyle} className="lastParagraphStyle">
            TORNEOS Y EVENTOS ONLINE DE POKER EN TODO EL PAIS.
          </p>
        </div>

        <img src={foto} alt="Imagen" className="foto-mano" />

        
       
 
      </div>

      <style jsx>{`
   /* Animations */

/* Animations */
@keyframes orbit {
  0% {
    transform: rotate(0deg) translateX(50px) rotate(0deg); /* Ajustado para evitar desbordamiento */
  }
  100% {
    transform: rotate(360deg) translateX(50px) rotate(-360deg); /* Ajustado para evitar desbordamiento */
  }
}

@keyframes bounce {
  0% {
    transform: translateY(0);
  }
  50% {
    transform: translateY(-20px);
  }
  100% {
    transform: translateY(0);
  }
}

@keyframes fall {
  0% {
    top: 0;
    opacity: 1;
  }
  100% {
    top: 100%;
    opacity: 0;
  }
}

@keyframes verticalJump {
  0% {
    transform: translateY(0) scale(0.5);
  }
  25% {
    transform: translateY(-20px) scale(1.2);
  }
  50% {
    transform: translateY(0) scale(1);
  }
  75% {
    transform: translateY(-10px) scale(1.1);
  }
  100% {
    transform: translateY(0) scale(1);
  }
}

@keyframes scaleUp {
  0% {
    transform: scale(0);
  }
  100% {
    transform: scale(1);
  }
}

@keyframes fuego {
  0% {
    text-shadow: 0 0 5px rgba(12, 4, 1, 0.7), 0 0 10px rgba(8, 2, 0, 0.7), 0 0 20px rgba(0, 0, 0, 0.7);
  }
  50% {
    text-shadow: 0 0 10px rgba(0, 0, 0, 0.8), 0 0 20px rgba(0, 0, 0, 0.8), 0 0 30px rgba(17, 7, 4, 0.8);
  }
  100% {
    text-shadow: 0 0 5px rgba(0, 0, 0, 0.7), 0 0 10px rgba(10, 9, 9, 0.7), 0 0 20px rgba(0, 0, 0, 0.7);
  }
}

@keyframes aureola {
  0% {
    transform: translateY(0) scale(1);
  }
  50% {
    transform: translateY(30px) scale(1.2);
  }
  100% {
    transform: translateY(0) scale(1);
  }
}

/* General Styles */
body, html {
  margin: 0;
  padding: 0;
  overflow-x: hidden; /* Evita el scroll horizontal */
}

.container {
  position: relative;
  width: 100%;
  height: 100vh;
  background-color: black;
  background-image: url(${pru});
  background-size: cover;
  background-position: center;
  overflow: hidden; /* Evita que los hijos desborden */
}

.paragraphContainerStyle {
  position: relative;
  top: 35%;
  left: 50%;
  transform: translateX(-50%); /* Centra el contenedor */
  color: white;
  text-align: center;
  font-family: 'Calibri', sans-serif;
  font-size: 10vw;
  width: 80%; /* Limita el ancho */
  height: 30%;
  max-width: 1200px; /* Establece un ancho máximo */
}

.lastParagraphStyle {
  font-size: 20px;
  color: #fff;
  animation: fuego 1s infinite;
  border: 1px solid red;
  padding: 35px;
  box-shadow: 0 0 20px rgba(134, 12, 8, 0.8), 0 0 770px rgba(189, 4, 4, 0.8);
  text-align: center;
  z-index: 1;
  position: relative;
  top: 35%;
  width: 60%;
  margin: 0 auto;
}

.paragraphStyle {
  font-size: 20px;
  color: #fff;
  border: 1px solid red;
  padding: 35px;
  box-shadow: 0 0 20px rgba(134, 12, 8, 0.8), 0 0 770px rgba(189, 4, 4, 0.8);
  text-align: justify;
  z-index: 1;
  position: relative;
  top: 23%;
  width: 50%;
  margin: 0 auto;
}

.foto-mano {
  position: absolute;
  opacity: 0.7;
  bottom: 0%;
  left: -2%;
  width: 50%;  /* Ajusta el tamaño en función del contenedor */
  height: auto;  /* Mantiene la proporción */
  z-index: 2;
}


.media-luna {
  position: absolute;
  top: 50%;
  right: 10%;
  transform: translateY(-50%);
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 2;
  width: 100%;
}

.textoStyle {
  position: absolute;
  top: 10%;
  left: 50%;
  transform: translate(-50%, -50%);
  font-size: 5vw;
  color: white;
  text-align: center;
  padding: 20px;
  text-shadow: 0 0 5px rgba(255, 165, 0, 0.8), 0 0 20px rgba(255, 165, 0, 0.8), 0 0 30px rgba(255, 165, 0, 0.8);
  font-family: Arial, sans-serif;
  font-weight: bold;
  z-index: 1;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}

.highlighted-paragraph {
  color: white;
  font-size: 1.9vw;
  padding: 17px;
  text-align: center;
  font-weight: bold;
  width: fit-content;
  margin-left: auto;
  margin-right: auto;
  position: absolute;
  top: 20%;
  right: 29%;
  animation: fuego 1s infinite;
  text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.2);
  background-color: rgba(255, 0, 0, 0.6);
  border-radius: 20px;
  padding: 15px 40px;
}

/* Image Animations */
.jumping-image {
  width: 120px;
  height: auto;
  margin: 10px;
  animation: verticalJump 1.5s ease-in-out infinite;
  position: absolute;
  transform-origin: center center;
  right: 10%; /* Ajustado para evitar desbordamiento */
  top: 450px;
}

.jumping-image1 {
  width: 100px;
  height: auto;
  margin: 10px;
  animation: verticalJump 1.5s ease-in-out infinite;
  position: absolute;
  transform-origin: center center;
  right: 10%; /* Ajustado para evitar desbordamiento */
  top: 300px;
}

.jumping-image2 {
  width: 100px;
  height: auto;
  margin: 10px;
  animation: verticalJump 1.5s ease-in-out infinite;
  position: absolute;
  transform-origin: center center;
  right: 20%; /* Ajustado para evitar desbordamiento */
  top: 140px;
}

.jumping-image3 {
  width: 250px;
  height: auto;
  margin: 10px;
  animation: verticalJump 1.5s ease-in-out infinite;
  position: absolute;
  transform-origin: center center;
  right: 10%; /* Ajustado para evitar desbordamiento */
  top: 600px;
}

/* Media Queries */
@media (max-width: 765px) {
   .container {
    display: flex;
    justify-content: center;
    align-items: center;
    flex-direction: column;
    height: 100vh;
    padding: 10px;
    box-sizing: border-box;
  }

  .textoStyle {
    font-size: 10vw; /* Ajusta el tamaño para pantallas más pequeñas */
  
        text-align: justify; /* Asegura que el texto esté centrado */
              left: 50%;
              top:12%

  }
 .mobileOnly {
    display: block; /* Muestra el <br /> solo en pantallas pequeñas */
  }
  .highlighted-paragraph {
    font-size: 4vw;
    padding: 3px;
    top: 30%;
    right: 22%;
  }

  .media-luna {
    display: flex;
    flex-direction: column;
    justify-content: center;
    top: 50%;
    right: 10%;
    transform: translate(-20%, -115%);
  }

  .media-luna img {
    width: 80%;
    margin-bottom: 55px;
  }
}

@media (max-width: 540px) {
  .foto-mano {
    display: none;
  }

  .highlighted-paragraph {
    font-size: 4vw;
    padding: 3px;
    top: 25%;
    right: 13%;
  }

  .media-luna {
    display: block;
    right: -5%;
  }

  .media-luna img {
    width: 10%;
  }
}

@media screen and (max-width: 540px) {
  .paragraphStyle,
  .lastParagraphStyle {
    font-size: 5vw;
    color: #ffffff;
    animation: fuego 1s infinite;
    border: 1px solid red;
    padding: 1em;
    box-shadow: 0 0 10px rgba(128, 0, 0, 0.8), 0 0 20px rgba(0, 0, 0, 0.8);
    text-align: justify;
    width: 100%;
    margin: 20px ;
    position: relative;
    left: -5%;
    box-sizing: border-box;
    line-height: 1.2;
    max-height: 40vh;
    overflow: hidden;
    word-wrap: break-word;
  }

  .paragraphContainerStyle {
    top: 23%;
    left: 50%;
    transform: translateX(-50%);
    color: white;
    text-align: center;
    font-family: 'Calibri', sans-serif;
    font-size: 5vw;
    height: 0%;
  }

  .highlighted-paragraph {
    font-size: 4vw;
    padding: 3px 25px;
    top: 80%;
    right: 2%;
  }
}
@media screen and (max-width: 600px) and (max-height: 932px) {
 
}

@media screen and (max-width: 1000px) and (min-width: 700px) and (max-height: 1600px) and (min-height: 1000px) {
  .jumping-image {
    width: 100px;
    right: 40px;
    top: 620px;
  }

  .jumping-image1 {
    right: 70px;
    top: 450px;
  }

  .jumping-image2 {
    right: 110px;
    top: 300px;
  }

  .jumping-image3 {
    right: 290px;
    top: 800px;
  }

  .paragraphStyle,
  .lastParagraphStyle {
    font-size: 16px;
  }

  .highlighted-paragraph {
    font-size: 4vw;
    padding: 3px;
    top: 30%;
    right: 13%;
  }
}
  @media (min-width: 768px) and (max-width: 1024px)  {
  .textoStyle {
    font-size: 7vw; /* Reducir el tamaño para modo horizontal */
  }

  .paragraphContainerStyle {
    font-size: 5vw;
    top: 20%;
    left: 50%;
    transform: translateX(-50%);
    height: 0%;
  }

  .highlighted-paragraph {
    font-size: 3.5vw;
    padding: 10px 30px;
    top: 50%;
    right: 12%;
  }

  .paragraphStyle,
  .lastParagraphStyle {
    font-size: 18px;
    padding: 20px;
    width: 80%; /* Ajustar el ancho */
    margin: 0 auto;
  }

  .jumping-image,
  .jumping-image1,
  .jumping-image2,
  .jumping-image3 {
    width: 150px;
    top: 550px;
    right: 15%;
  }

  .media-luna {
    right: 12%;
    top: 50%;
    transform: translateY(-50%);
  }
}@media (min-width: 768px) {
  .mobileOnly {
    display: none; /* Oculta el <br /> en pantallas grandes */
  }
}
      `}</style>
    </div>
  );
};

export default Home;
