import React from 'react';
import '../estilos/Header.css'; // Importamos el archivo de estilos
import Promociones from './Promociones';
import { BrowserRouter as Router, Routes, Route, Link } from 'react-router-dom';

// Suponiendo que tienes un logo en la carpeta 'assets'
import logo from '../assets/ecuapoker.png';

const Header = ({ homeRef, aboutRef, servicesRef, clubsRef, promotionsRef, contactRef }) => {
  const [isMenuOpen, setIsMenuOpen] = React.useState(false); // Estado para controlar la apertura del menú

  const toggleMenu = () => {
    setIsMenuOpen(!isMenuOpen); // Alterna entre abierto y cerrado
  };

  // Función que hace scroll hacia el componente correspondiente
  const scrollToSection = (ref) => {
    ref.current.scrollIntoView({ behavior: 'smooth' });
  };

  return (
  
    <header className="header">
      <div className="logo">
        <img src={logo} alt="Logo" />
      </div>
      {/* Icono de la hamburguesa para pantallas pequeñas */}
      <div className="hamburger" onClick={toggleMenu}>
        &#9776; {/* Símbolo de la hamburguesa */}
      </div>

      <div className="social-icons">
        <a href="https://wa.me/+593993149096" className="social-icon" target="_blank" rel="noopener noreferrer">
          <i className="fab fa-whatsapp"></i>
        </a>
        <a href="https://www.facebook.com/share/15cWunEuUo/" className="social-icon" target="_blank" rel="noopener noreferrer">
          <i className="fab fa-facebook-f"></i>
        </a>
        <a href="https://www.youtube.com/@Ecuapoker_ec" className="social-icon" target="_blank" rel="noopener noreferrer">
          <i className="fab fa-youtube"></i>
        </a>
        <a href="https://www.instagram.com/ecuapoker.ec?igsh=ZjhkeXlpZjQ1ZHRh" className="social-icon" target="_blank" rel="noopener noreferrer">
          <i className="fab fa-instagram"></i>
        </a>
      </div>

      {/* <li><Link to="/bonos"><strong>Promociones</strong></Link></li>*/}

      <nav className={`nav-menu ${isMenuOpen ? 'mobile-menu' : ''}`}>
        <ul>
        <li><Link to="/"><strong>Inicio</strong></Link></li>
        <li><Link to="/Nosotros"><strong>Nosotros</strong></Link></li>
        <li><Link to="/Eventos"><strong>Eventos</strong></Link></li>
        <li><Link to="/Clubs"><strong>Clubs</strong></Link></li>

          
          
          
          <li><Link to="/Contacto"><strong>Contacto</strong></Link></li>
          <li><Link to="/Preguntas"><strong>Preguntas</strong></Link></li>
        </ul>
      </nav>
    </header>
  );
};

export default Header;