import React from 'react';
import { useLocation } from 'react-router-dom';
import { DownOutlined } from '@ant-design/icons';

const Flechabajo = ({ homeRef }) => {
  const location = useLocation(); // Obtiene la ubicación actual

  const scrollToHome = () => {
    if (homeRef.current) {
      homeRef.current.scrollIntoView({ behavior: 'smooth' });
    }
  };

  if (location.pathname !== '/') {
    return null; // No renderizar fuera de la página principal
  }

  return (
    <button
      onClick={scrollToHome}
      style={styles.button}
      aria-label="Scroll to top"
    >
      <DownOutlined style={{ fontSize: '2.2vw', color: 'red' }} />
    </button>
  );
};

const styles = {
  button: {
    position: 'fixed',
    bottom: '2rem',
    left: '1rem',
    backgroundColor: '#fff',
    border: 'none',
    borderRadius: '50%',
    width: '50px',
    height: '50px',
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    cursor: 'pointer',
    boxShadow: '0px 4px 10px rgba(0, 0, 0, 0.3)',
    transition: 'background-color 0.3s, transform 0.3s',
    zIndex: 1000,
  },
  '@media (max-width: 768px)': {
    button: {
      width: '40px',
      height: '40px',
      bottom: '1.5rem',
      left: '1.5rem',
    }
  },
  '@media (max-width: 480px)': {
    button: {
      width: '35px',
      height: '35px',
      bottom: '1rem',
      left: '1rem',
    }
  }
};

export default Flechabajo;
