import React, { useState, useEffect } from 'react';
import Estrellas from './Estrellas';
import '../estilos/Comentario.css';
import fotodd from '../assets/DDDDS.png';  

const preguntas = [
  { 
      nombre: "  ¿Por qué unirse a un club de poker en Ecuador con EcuaPoker?",
    comentario: "Unirse a un club de poker con EcuaPoker es la mejor manera de disfrutar del poker. Con clubs exclusivos en Guayaquil, Quito y otras ciudades, ofrecemos una experiencia única para jugar poker en un ambiente seguro y profesional. Participa en nuestros eventos y torneos online, donde la competencia es justa y la camaradería entre jugadores es incomparable. Ya seas un jugador principiante o experto, encontrarás en nuestros clubs el lugar perfecto para mejorar tu juego y disfrutar del poker en Guayaquil, Quito y más." 
  },
  { 
    nombre: "  ¿Cómo puedo jugar en los torneos de EcuaPoker?", 
    comentario: "Puedes participar en nuestros torneos simplemente contáctanos al +593 98 675 6667 para inscribirte. Si prefieres registrarte directo, nuestra app ofrece la facilidad de unirte a eventos de manera más rápida y acceder a beneficios exclusivos." 
  },
  { 
    nombre: "¿Cuáles son los Métodos de Pago?", 
    comentario: "En ECUAPOKER, ofrecemos una amplia variedad de métodos de pago seguros y convenientes para que disfrutes de una experiencia sin complicaciones. Nos aseguramos de que todas tus transacciones, tanto de depósitos como de retiros, se procesen de manera rápida y segura." 
  },
  { 
    nombre: "¿Quieres saber más sobre nosotros?", 
    comentario: "Desde 2018, ECUAPOKER ha sido la plataforma líder de poker online en Ecuador, ofreciendo una experiencia de juego segura, confiable y emocionante para jugadores de todos los niveles. A lo largo de los años, hemos organizado algunos de los torneos más grandes y prestigiosos en el país, con premios que han alcanzado hasta 50k. Nuestro compromiso es ofrecer torneos online y online de alta calidad, incluyendo competiciones con premios de 20K, 30K y 50K, donde jugadores de todo Ecuador y Latinoamérica pueden competir en un entorno seguro y justo. ECUAPOKER es sinónimo de excelencia en el poker." 
  },
];

const Comentario = () => {
  const [comentarioIndex, setComentarioIndex] = useState(0);
  const [isVisible, setIsVisible] = useState(Array(preguntas.length).fill(false)); // Estado para manejar la visibilidad de las respuestas

  // Cambiar las preguntas cada 5 segundos
  useEffect(() => {
    const interval = setInterval(() => {
      setComentarioIndex((prevIndex) => (prevIndex + 1) % preguntas.length); // Cambiar a la siguiente pregunta
    }, 5000);

    return () => clearInterval(interval);
  }, []);

  // Función para alternar la visibilidad de la respuesta
  const toggleVisibility = (index) => {
    const newVisibility = [...isVisible];
    newVisibility[index] = !newVisibility[index]; // Alternar visibilidad
    setIsVisible(newVisibility);
  };

  return (
    <div className="Comentario">
      <Estrellas />

      {/* Contenedor para el video */}
      
       
        
      <img src={fotodd} alt="Imagen" className="fotodd" />
        
       
      

      <div className="preguntasfre">
        Preguntas Frecuentes 
      </div>
      <p className="jombriel">Resuelve tus dudas sobre cómo participar en los torneos de poker en Ecuador y descubre por qué EcuaPoker es la mejor opción para los jugadores.</p>
      {/* Preguntas */}
      <div className="preguntas">
        {/* Mostrar preguntas dinámicamente */}
        {preguntas.map((comentario, index) => (
          <div key={index} className="comen">
            <div className="comen-texto">
              <p className="pregunombre">{comentario.nombre}</p>
              <button
                className="toggle-button"
                onClick={() => toggleVisibility(index)}
              >
                {isVisible[index] ? '♣️' : '🔷'} {/* Mostrar + o - */}
              </button>
              {isVisible[index] && <p className="contenidopreg">{comentario.comentario}</p>} {/* Mostrar la respuesta si es visible */}
            </div>
          </div>
        ))}
      </div>
    </div>
  );
};

export default Comentario;
