import React, { useState } from "react";
import { Modal, Button, Input, Radio, Form, Row, Col, Tabs, notification, Upload } from "antd";
import axios from "axios";
import { InboxOutlined } from "@ant-design/icons";
import foto1 from '../assets/logosApps/gggpoker.png';
import foto2 from '../assets/logosApps/pokerbross.png';
import foto3 from '../assets/logosApps/pppoker.png';
import foto4 from '../assets/logosApps/suprema2024.png';
import foto5 from '../assets/logosApps/LOGO X POKER.png';
import '../estilos/Formularioinicio.css';

const { TabPane } = Tabs;
const endpoint = "https://ecua-poker.com/public/api/insertarusuario";
// const endpoint = "http://192.168.100.226:8000/api/insertarusuario"; 

const ModalForm = ({ isOpen, onClose, type, message }) => {
    const [form] = Form.useForm();
    const [club, setClub] = useState("");
    const [belongsToClub, setBelongsToClub] = useState(null);
    const [formVisible, setFormVisible] = useState(false);
    const [messageVisible, setMessageVisible] = useState(false);

    const handleClubChange = (e) => {
        setClub(e.target.value);
        setMessageVisible(true);
    };

    const handleBelongsChange = (e) => {
        setBelongsToClub(e.target.value);
        if (e.target.value === "yes") {
            setFormVisible(true);
        } else {
            setFormVisible(false);
        }
    };

    const onFinish = async (values) => {
        const formData = new FormData();
        formData.append("correo_usuario", values.email);
        formData.append("celular_usuario", values.telefono);
        formData.append("identificacion", values.identificacion);
        formData.append("referido", values.referido);
        formData.append("usuario", values.usuario);
        formData.append("club", club);
        if (values.foto1) formData.append("foto1", values.foto1.file);
        if (values.foto2) formData.append("foto2", values.foto2.file);

        try {
            const response = await axios.post(endpoint, formData, {
                headers: { "Content-Type": "multipart/form-data" },
            });

            // Maneja la respuesta del backend
            console.log("Respuesta de la API:", response.data); // Ver la respuesta en consola

            notification.success({
                message: "Registro Guardado",
                description: typeof response.data.message === "string"
                    ? response.data.message // Si es una cadena, la muestra directamente
                    : JSON.stringify(response.data.message), // Si es un objeto, lo convierte a cadena
                placement: "topRight",
                duration: 20,
            });

            onClose();
        } catch (error) {
            console.error("Error en la solicitud:", error.response?.data || error);

            // Maneja el error del backend
            notification.error({
                message: "Error al Guardar",
                description: error.response?.data.message || "Hubo un problema al guardar el registro.",
                placement: "topRight",
                duration: 20,
            });
        }
    };



    const clubHelpMessage = club === "Ecuapoker VIP" ?
        (
            <span style={{ color: "green" }}>
                Completa el formulario para poder participar proximamente en bonos exclusivos para miembros de  <strong>Ecuapoker</strong>.
                Si tienes alguna duda, haz clic{" "}
                <a href="https://wa.me/+593993149096" target="_blank" rel="noopener noreferrer">
                    aquí
                </a>{" "}
                para más información.
            </span>

        ) :
        (
            <span style={{ color: "green" }}>
                Completa el formulario para poder participar proximamente en bonos exclusivos para miembros de  <strong>Ecuapoker</strong>.
                Si tienes alguna duda, haz clic{" "}
                <a href="https://wa.me/+593993149096" target="_blank" rel="noopener noreferrer">
                    aquí
                </a>{" "}
                para más información.
            </span>
        );

    return (
        <Modal
            open={isOpen}
            onCancel={onClose}
            footer={null}
            title={
                <span style={{
                    fontSize: "24px",
                    fontWeight: "bold",
                    color: "#1890ff",
                    textAlign: "center"
                }}>
                    {type === "form" ? "🎉 Registro Bonos Ecuapoker 🎉" : message}
                </span>
            }
            width="100%"
            style={{ maxWidth: "600px" }}
            destroyOnClose
        >
            {type === "form" ? (
                <Form
                    form={form}
                    onFinish={onFinish}
                    layout="vertical"
                    style={{
                        backgroundColor: "#e4edee",
                        padding: "30px",
                        borderRadius: "8px",
                        boxShadow: "0 2px 10px rgba(0, 0, 0, 0.1)",
                    }}
                >
                    {/* Pregunta si pertenece */}
                    <Row gutter={[16, 16]}>
                        <Col xs={24}>
                            <Form.Item label="¿Perteneces a un club de Ecuapoker?" name="pertenece">
                                <Radio.Group onChange={handleBelongsChange} value={belongsToClub}>
                                    <Radio value="yes">Sí</Radio>
                                    <Radio value="no">No</Radio>
                                </Radio.Group>
                            </Form.Item>
                        </Col>
                    </Row>

                    {/* Si el usuario pertenece, muestra el formulario */}
                    {formVisible && (
                        <>
                            <Row gutter={[16, 16]}>
                                <Col xs={24} sm={12}>
                                    <Form.Item
                                        label="Correo Electrónico"
                                        name="email"
                                        rules={[
                                            {
                                                required: true,
                                                type: "email",
                                                message: "Por favor ingrese un correo válido",
                                            },
                                        ]}
                                    >
                                        <Input />
                                    </Form.Item>
                                </Col>

                                <Col xs={24} sm={12}>
                                    <Form.Item
                                        label="Número de Celular"
                                        name="telefono"
                                        rules={[
                                            {
                                                required: true,
                                                pattern: /^\+?[0-9]\d{1,14}$/,
                                                message: "Por favor ingrese un número válido",
                                            },
                                        ]}
                                    >
                                        <Input placeholder="+593987654321" />
                                    </Form.Item>
                                </Col>

                                <Col xs={24}>
                                    <Form.Item label="¿Club al que perteneces?">
                                        <Tabs defaultActiveKey="1">
                                            <TabPane
                                                tab={<img src={foto3} alt="PPPoker" className="pulsing-image" style={{ width: 50, height: 50 }} />}
                                                key="1"
                                            >
                                                <Form.Item
                                                    validateStatus={club ? (club === "Ecuapoker VIP" ? "success" : "error") : ""}
                                                    help={club ? clubHelpMessage : ""}
                                                >
                                                    <Radio.Group onChange={handleClubChange} value={club}>
                                                        <Radio value="White"><b>WHITE</b></Radio>
                                                        <Radio value="Red"><b>RED</b></Radio>
                                                    </Radio.Group>
                                                </Form.Item>
                                            </TabPane>

                                            <TabPane
                                                tab={<img src={foto2} alt="Pokerbross" className="pulsing-image" style={{ width: 50, height: 50 }} />}
                                                key="2"
                                            >
                                                <Form.Item
                                                    validateStatus={club ? (club === "Ecuapoker VIP" ? "success" : "error") : ""}
                                                    help={club ? clubHelpMessage : ""}
                                                >
                                                    <Radio.Group onChange={handleClubChange} value={club}>
                                                        <Radio value="JacksUp"><b>JACKSUP</b></Radio>
                                                        <Radio value="Jocker Face"><b>JOCKER FACE</b></Radio>
                                                        <Radio value="Ecuapoker VIP"><b>ECUAPOKER VIP</b></Radio>
                                                    </Radio.Group>
                                                </Form.Item>
                                            </TabPane>

                                            <TabPane
                                                tab={<img src={foto1} alt="GGPoker" className="pulsing-image" style={{ width: 50, height: 50 }} />}
                                                key="3"
                                            >
                                                <Form.Item
                                                    validateStatus={club ? (club === "Ecuapoker VIP" ? "success" : "error") : ""}
                                                    help={club ? clubHelpMessage : ""}
                                                >
                                                    <Radio.Group onChange={handleClubChange} value={club}>
                                                        <Radio value="Tripoker"><b>ECUATEAM</b></Radio>
                                                    </Radio.Group>
                                                </Form.Item>
                                            </TabPane>

                                            <TabPane
                                                tab={<img src={foto4} alt="suprema" className="pulsing-image" style={{ width: 50, height: 50 }} />}
                                                key="4"
                                            >
                                                <Form.Item
                                                    validateStatus={club ? (club === "Ecuapoker VIP" ? "success" : "error") : ""}
                                                    help={club ? clubHelpMessage : ""}
                                                >
                                                    <Radio.Group onChange={handleClubChange} value={club}>
                                                        <Radio value="Ecuapoker"><b>ECUAPOKER</b></Radio>
                                                    </Radio.Group>
                                                </Form.Item>
                                            </TabPane>

                                            <TabPane
                                                tab={<img src={foto5} alt="x poker" className="pulsing-image" style={{ width: 50, height: 50 }} />}
                                                key="4"
                                            >
                                                <Form.Item
                                                    validateStatus={club ? (club === "Ecuapoker VIP" ? "success" : "error") : ""}
                                                    help={club ? clubHelpMessage : ""}
                                                >
                                                    <Radio.Group onChange={handleClubChange} value={club}>
                                                        <Radio value="Ecuapoker"><b>ECUAPOKER</b></Radio>
                                                    </Radio.Group>
                                                </Form.Item>
                                            </TabPane>
                                        </Tabs>
                                    </Form.Item>
                                </Col>



                                <Col xs={24} sm={12}>
                                    <Form.Item
                                        label="Identificacion"
                                        name="identificacion"
                                        rules={[
                                            {
                                                required: true,
                                                pattern: /^\+?[0-9]\d{1,14}$/,
                                                message: "Ingrese su identificación."
                                            }
                                        ]}
                                    >
                                        <Input />
                                    </Form.Item>
                                </Col>



                                {/* Upload Imagen 1 */}
                                <Form.Item label="Foto identificación." name="foto1">
                                    <Upload
                                        beforeUpload={(file) => {
                                            form.setFieldsValue({ foto1: { file } });
                                            return false;
                                        }}
                                        showUploadList={true}
                                        accept="image/*"
                                    >
                                        <Button icon={<InboxOutlined />}>Subir foto de la parte frontal de la identificación</Button>
                                    </Upload>
                                </Form.Item>

                                <Form.Item label="Foto tuya con la identificacion" name="foto2">
                                    <Upload
                                        beforeUpload={(file) => {
                                            form.setFieldsValue({ foto2: { file } });
                                            return false;
                                        }}
                                        showUploadList={true}
                                        accept="image/*"
                                    >
                                        <Button icon={<InboxOutlined />}>Subir foto tuya mostrando tu identificación</Button>
                                    </Upload>
                                </Form.Item>

                                <Col xs={24} sm={12}>
                                    <Form.Item
                                        label="Usuario"
                                        name="usuario"
                                        rules={[{ required: true, message: "Ingrese su Nick" }]}
                                    >
                                        <Input />
                                    </Form.Item>
                                </Col>
                                <Col xs={24} sm={12}>
                                    <Form.Item
                                        label="ID Referido (Opcional)"
                                        name="referido"

                                    >
                                        <Input />
                                    </Form.Item>
                                </Col>
                                <span style={{ color: "red" }}>
                                    Una vez hayas completado el formulario, el siguiente paso es seguirnos en{" "}
                                    <a href="https://www.instagram.com/ecuapoker.ec?igsh=ZjhkeXlpZjQ1ZHRh" target="_blank" rel="noopener noreferrer">
                                        nuestro Instagram
                                    </a>{" "}
                                    y enviarnos una captura de pantalla a través de{" "}
                                    <a href="https://wa.me/+593993149096" target="_blank" rel="noopener noreferrer">
                                        WhatsApp
                                    </a>.
                                </span>

                            </Row>

                            <div style={{ display: "flex", justifyContent: "space-between", marginTop: 20 }}>
                                <Button type="primary" htmlType="submit">
                                    Enviar
                                </Button>
                                <Button type="default" onClick={onClose}>
                                    Cerrar
                                </Button>
                            </div>
                        </>
                    )}

                    {/* Si el usuario no pertenece, muestra el botón de WhatsApp */}
                    {!formVisible && belongsToClub === "no" && (
                        <div style={{ textAlign: "center" }}>
                            <p>
                                Te ayudamos a unirte nuestra comunidad en <b>Ecuapoker</b>, para que puedas disfrutar del mejor poker online, dad clic en el botón para que un asesor te guie paso a paso.</p>

                            <Button
                                type="primary"
                                href="https://wa.me/+593993149096"
                                target="_blank"
                            >
                                Soporte en WhatsApp
                            </Button>
                        </div>
                    )}
                </Form>
            ) : (
                <>
                    <p>{message}</p>
                    <Button type="primary" onClick={onClose}>
                        Cerrar
                    </Button>
                </>
            )}
        </Modal>
    );
};

export default ModalForm;
