import React, { useRef, useState, useEffect } from 'react';
import Estrellas from './components/Estrellas';
import Header from './components/Header';
import Home from './components/Home';
import Navbar from './components/Navbar';
import Cartas from './components/Cartas';
import Tokens from './components/Tokens';
import Torres from './components/Torres';
import Videos from './components/Videos';
import Comentario from './components/Comentario';
import Contacto from './components/Contacto';
import Pie from './components/Pie';
import Derecho from './components/Derecho';
import ScrollToTopButton from './components/ScrollToTopButton';
import Nosotros from './components/comp-contactos/Nosotros.js';
import Eventos from './components/comp-contactos/Eventos.js';
import Contac from './components/comp-contactos/Contac.js';
import Preguntas from './components/comp-contactos/Preguntas.js';
import Modal from './Modal/FormularioInicio';

import Clubes from './components/comp-contactos/Clubes.js';

import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';

import Flechabajo from './components/Flechabajo';
import Promociones from './components/Promociones';


function App() {

    const homeRef = useRef(null);
    const aboutRef = useRef(null);
    const servicesRef = useRef(null);
    const clubsRef = useRef(null);
    const promotionsRef = useRef(null);
    const contactRef = useRef(null);
    const [isModalOpen, setIsModalOpen] = useState(true);
    const [modalType, setModalType] = useState('form');
    const [message, setMessage] = useState('');
    const [nombre, setNombre] = useState('');

    const openModal = () => {
        setIsModalOpen(true);
    };

    const closeModal = () => {
        setIsModalOpen(false);
    };

    const handleFormSubmit = (values) => {
        console.log('Formulario enviado con los siguientes valores:', values);
        setNombre(values.nombre);
        setModalType('success');
        setMessage('¡Enviado con éxito!');
    };

    useEffect(() => {
        openModal();
    }, []);
    return (
        <div className="App">
            <Modal
                isOpen={isModalOpen}
                onClose={closeModal}
                type={modalType}
                message={modalType === 'form' ? message : 'Formulario enviado'}
                onFormSubmit={handleFormSubmit}
            />
            <Router>

                <Estrellas />

                <Header
                    homeRef={homeRef}
                    aboutRef={aboutRef}
                    servicesRef={servicesRef}
                    clubsRef={clubsRef}
                    promotionsRef={promotionsRef}
                    contactRef={contactRef}
                />

                {/* Aquí se renderizan las rutas de contenido */}
                <Routes>
                    <Route path="/" element={
                        <main>
                            <div ref={homeRef}><Home /></div>
                            <Navbar />
                            <div ref={clubsRef}><Tokens /></div>
                            <div ref={aboutRef}><Cartas /></div>

                            <div ref={promotionsRef}><Torres /></div>
                            <div ref={contactRef}><Videos /></div>
                            <div ref={servicesRef}><Comentario /></div>
                            <div ref={contactRef}><Contacto /></div>
                            <Pie />
                            <Derecho />
                        </main>
                    } />

                    {/* Ruta para Promociones */}
                    <Route path="/bonos" element={<Promociones />} />
                    <Route path="/Nosotros" element={<Nosotros />} />
                    <Route path="/Eventos" element={<Eventos />} />
                    <Route path="/Clubs" element={<Clubes />} />
                    <Route path="/Contacto" element={<Contac />} />
                    <Route path="/Preguntas" element={<Preguntas />} />


                </Routes>

                <ScrollToTopButton homeRef={homeRef} />
                <Flechabajo homeRef={contactRef} />
            </Router>
        </div>
    );
}

export default App;
