<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('productos', function (Blueprint $table) {
            $table->id('id_producto');
            $table->text('descripcion')->nullable(false);
            $table->integer('cantidad')->nullable(false);
            $table->longText('imagen')->nullable;

            $table->date('fecha_caducidad')->nullable();
            $table->text('mantenimiento')->nullable();
            $table->unsignedBigInteger('id_tipoproducto');
            $table->unsignedBigInteger('id_departamento');
            $table->unsignedBigInteger('id_proviene_producto');
            $table->boolean('estado')->default(1);
            $table->timestamps();


            $table->foreign('id_tipoproducto')->references('id_tipo')->on('tipo_productos')->onDelete('cascade');
            $table->foreign('id_departamento')->references('id_departamento')->on('departamentos')->onDelete('cascade');
            $table->foreign('id_proviene_producto')->references('id_proviene_producto')->on('proviene_productos')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('productos');
    }
};
