<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Producto extends Model
{
    use HasFactory;

    protected $table = 'productos'; // Nombre correcto de la tabla
    protected $primaryKey = 'id_producto'; // Definir la clave primaria
    public $timestamps = true; // Habilitar timestamps

    protected $fillable = [
        'descripcion',
        'cantidad',
        'fecha_caducidad',
        'mantenimiento',
        'imagen',
        'id_tipoproducto',
        'id_departamento',
        'id_proviene_producto',
        'estado'
    ];

    // Relación con TipoProducto
    public function tipoProducto()
    {
        return $this->belongsTo(TipoProducto::class, 'id_tipoproducto', 'id_tipo');
    }

    // Relación con Departamento
    public function departamento()
    {
        return $this->belongsTo(Departamento::class, 'id_departamento', 'id_departamento');
    }

    // Relación con ProvieneProducto
    public function provieneProducto()
    {
        return $this->belongsTo(ProvieneProducto::class, 'id_proviene_producto', 'id_proviene_producto');
    }
}
