<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Departamento extends Model
{
    use HasFactory;

    protected $table = 'departamentos'; // Nombre correcto de la tabla
    protected $primaryKey = 'id_departamento'; // Definir la clave primaria
    public $timestamps = true; // Habilitar timestamps

    protected $fillable = ['descripcion', 'estado', 'id_sucursal'];

    // Relación con Sucursal
    public function sucursal()
    {
        return $this->belongsTo(Sucursal::class, 'id_sucursal', 'id_sucursal');
    }
}
