<?php

namespace App\Http\Controllers;

use App\Models\TipoProducto;
use Illuminate\Http\Request;

class TipoProductoController extends Controller
{
    // Mostrar todos los registros con paginación
    public function index()
    {
        $tipos = TipoProducto::paginate(10); // Paginación de 10 registros por página
        return view('tipos-producto.index', compact('tipos'));
    }

    // Mostrar el formulario de creación
    public function create()
    {
        return view('tipos-producto.create');
    }

    // Crear un nuevo registro
    public function store(Request $request)
    {
        $request->validate([
            'tipo' => 'required|string|max:255',
            'descripcion' => 'required|string',
            'estado' => 'required|boolean',
        ]);

        TipoProducto::create($request->all()); // Crear un nuevo tipo de producto
        return redirect()->route('tipos-producto.index')->with('success', 'Tipo de producto creado exitosamente');
    }

    // Mostrar el formulario de edición
    public function edit(TipoProducto $tipoProducto)
    {
        return view('tipos-producto.edit', compact('tipoProducto'));
    }

    // Actualizar un registro existente
    public function update(Request $request, TipoProducto $tipoProducto)
    {
        $request->validate([
            'tipo' => 'required|string|max:255',
            'descripcion' => 'required|string',
            'estado' => 'required|boolean',
        ]);

        $tipoProducto->update($request->all()); // Actualizar el tipo de producto
        return redirect()->route('tipos-producto.index')->with('success', 'Tipo de producto actualizado exitosamente');
    }


    // Eliminar un registro
    public function destroy(TipoProducto $tipoProducto)
    {
        $tipoProducto->delete(); // Eliminar el tipo de producto
        return redirect()->route('tipos-producto.index')->with('success', 'Tipo de producto eliminado exitosamente');
    }
}
