<?php

namespace App\Http\Controllers;

use App\Models\ProvieneProducto;
use Illuminate\Http\Request;

class ProvieneProductoController extends Controller
{
    // Mostrar todos los registros con paginación
    public function index()
    {
        $provieneProductos = ProvieneProducto::paginate(10); // Paginación de 10 registros por página
        return view('proviene-producto.index', compact('provieneProductos'));
    }

    // Mostrar el formulario de creación
    public function create()
    {
        return view('proviene-producto.create');
    }

    // Crear un nuevo registro
    public function store(Request $request)
    {
        $request->validate([
            'direccion' => 'required|string|max:255',
            'descripcion' => 'required|string',
            'estado' => 'required|boolean',
            'origen' => 'required|string|max:255',
        ]);

        ProvieneProducto::create($request->all()); // Crear un nuevo registro de ProvieneProducto
        return redirect()->route('proviene-producto.index')->with('success', 'Proviene producto creado exitosamente');
    }

    // Mostrar el formulario de edición
    public function edit(ProvieneProducto $provieneProducto)
    {
        return view('proviene-producto.edit', compact('provieneProducto'));
    }

    // Actualizar un registro existente
    public function update(Request $request, ProvieneProducto $provieneProducto)
    {
        $request->validate([
            'direccion' => 'required|string|max:255',
            'descripcion' => 'required|string',
            'estado' => 'required|boolean',
            'origen' => 'required|string|max:255',
        ]);

        $provieneProducto->update($request->all()); // Actualizar el proviene producto
        return redirect()->route('proviene-producto.index')->with('success', 'Proviene producto actualizado exitosamente');
    }

    // Eliminar un registro
    public function destroy(ProvieneProducto $provieneProducto)
    {
        $provieneProducto->delete(); // Eliminar el proviene producto
        return redirect()->route('proviene-producto.index')->with('success', 'Proviene producto eliminado exitosamente');
    }
}
