<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Departamento;
use App\Models\Sucursal;

class DepartamentoController extends Controller
{
    public function index()
    {
        $departamentos = Departamento::with('sucursal')->paginate(10);
        return view('departamentos.index', compact('departamentos'));
    }

    public function create()
    {
        $sucursales = Sucursal::all();
        return view('departamentos.create', compact('sucursales'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'descripcion' => 'required|string|max:255',
            'estado' => 'required|boolean',
            'id_sucursal' => 'required|exists:sucursales,id_sucursal',
        ]);

        Departamento::create($request->all());
        return redirect()->route('departamentos.index')->with('success', 'Departamento creado exitosamente');
    }

    public function edit(Departamento $departamento)
    {

        $sucursales = Sucursal::all();

        return view('departamentos.edit', compact('departamento', 'sucursales'));
    }
    public function update(Request $request, Departamento $departamento)
    {
        $request->validate([
            'descripcion' => 'required|string|max:255',
            'estado' => 'required|boolean',
            'id_sucursal' => 'required|exists:sucursales,id_sucursal',
        ]);

        $departamento->update([
            'descripcion' => $request->descripcion,
            'estado' => $request->estado,
            'id_sucursal' => $request->id_sucursal,
        ]);

        return redirect()->route('departamentos.index')->with('success', 'Departamento actualizado exitosamente');
    }


    public function destroy(Departamento $departamento)
    {
        $departamento->delete();
        return redirect()->route('departamentos.index')->with('success', 'Departamento eliminado exitosamente');
    }
}
